/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.yandexTaxi.ibus.process;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableNameUtil;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.yandexTaxi.IBusYandexTaxiParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.yandexTaxi.YandexTaxiExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.yandexTaxi.YandexTaxiProductData;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;

public class YandexTaxiParserFindTravellerProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        EntityReference customerRef;
        YandexTaxiExchangeDocument document = (YandexTaxiExchangeDocument)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT);
        YandexTaxiProductData data = document.getProduct();
        EntityReference personRef = (EntityReference)ctx.getObject((Enum)IBusYandexTaxiParserContextKeys.AGENT);
        if (personRef == null) {
            document.getMessages().add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0434\u043b\u044f \u2116 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 {0} \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a\u0430", (Object[])new Object[]{data.getProductNumber()}));
            return;
        }
        Traveller traveller = new Traveller();
        Person person = (Person)EntityStorage.get().resolve(personRef).getEntity();
        traveller.setPassenger(personRef);
        if (!person.getPassports().isEmpty()) {
            traveller.setPassport((Passport)person.getPassports().get(0));
        }
        traveller.setName(PersonalLocalizableNameUtil.buildFullName((PersonalLocalizableName)person, (boolean)false, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        traveller.setBirthday(person.getBirthday());
        traveller.getCommunications().addAll(person.getCommunications());
        ctx.putObject((Enum)IBusYandexTaxiParserContextKeys.TRAVELLER, (Object)traveller);
        List corporateClients = ProfileHelper.getEmploymentsRefs((Person)person, (boolean)false).stream().map(arg_0 -> ((EntityStorage)EntityStorage.get()).resolve(arg_0)).filter(Objects::nonNull).filter(orgCtr -> ((Organization)orgCtr.getEntity()).getTypes().contains(OrganizationType.CORPORATE_CLIENT)).map(EntityContainer::toReference).distinct().collect(Collectors.toList());
        if (corporateClients.size() == 1) {
            customerRef = (EntityReference)corporateClients.get(0);
        } else {
            EntityReference mainEmploymentRef = ProfileHelper.getMainEmploymentRef((Person)person);
            customerRef = corporateClients.stream().filter(clientRef -> Objects.equals(clientRef, mainEmploymentRef)).findAny().orElse(null);
        }
        if (customerRef == null) {
            document.getMessages().add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0434\u043b\u044f \u2116 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 {0} \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043a\u043b\u0438\u0435\u043d\u0442\u0430", (Object[])new Object[]{data.getProductNumber()}));
        }
        ctx.putObject((Enum)IBusYandexTaxiParserContextKeys.CUSTOMER_PROFILE, (Object)customerRef);
    }
}

