/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.yandexTaxi.ibus.process;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiHelper;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiProduct;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiProductSettings;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.VatValue;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.TransactionType;
import com.gridnine.xtrip.common.parsers.model.yandexTaxi.IBusYandexTaxiParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.yandexTaxi.YandexTaxiExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.yandexTaxi.YandexTaxiProductData;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.helpers.ParsersHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;

public class YandexTaxiParserPrepareBookingProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        YandexTaxiExchangeDocument document = (YandexTaxiExchangeDocument)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT);
        YandexTaxiProductData data = document.getProduct();
        EntityContainer bookingFileCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusYandexTaxiParserContextKeys.BOOKING_FILE_CTR);
        BookingFile bookingFile = (BookingFile)bookingFileCtr.getEntity();
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusYandexTaxiParserContextKeys.RESERVATION);
        TaxiProduct product = (TaxiProduct)ctx.getMandatoryObject((Enum)IBusYandexTaxiParserContextKeys.PRODUCT);
        EntityReference agentRef = (EntityReference)ctx.getObject((Enum)IBusYandexTaxiParserContextKeys.AGENT);
        EntityReference agencyRef = ProfileHelper.findOrganizationRef((String)"001");
        EntityReference salesPointRef = ProfileHelper.findSalesPointRef((String)"001");
        Traveller traveller = (Traveller)ctx.getObject((Enum)IBusYandexTaxiParserContextKeys.TRAVELLER);
        EntityReference customerProfileRef = (EntityReference)ctx.getObject((Enum)IBusYandexTaxiParserContextKeys.CUSTOMER_PROFILE);
        DictionaryReference cityRef = (DictionaryReference)ctx.getObject((Enum)IBusYandexTaxiParserContextKeys.CITY);
        DictionaryReference carClassRef = (DictionaryReference)ctx.getObject((Enum)IBusYandexTaxiParserContextKeys.CAR_CLASS);
        bookingFile.setAgency(agencyRef);
        bookingFile.setCustomerProfile(customerProfileRef);
        bookingFile.getTravellers().clear();
        bookingFile.getTravellers().add(traveller);
        bookingFile.setCreateDate(new Date());
        reservation.setSalesPoint(salesPointRef);
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, null, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)data.getProductNumber());
        reservation.setResDate(data.getIssueDate());
        reservation.setSubagency(agencyRef);
        reservation.setBookingAgent(agentRef);
        reservation.setType(ReservationType.OFFLINE);
        product.setSalesPoint(salesPointRef);
        product.setTicketType(TicketType.OWN);
        product.setStatus(ParsersHelper.getStatus((TransactionType)data.getTransactionType()));
        product.setIssueDate(data.getIssueDate());
        product.getTravellers().clear();
        product.getTravellers().add(traveller);
        product.setAgent(agentRef);
        TaxiHelper.setAgency((TaxiProduct)product, (EntityReference)agencyRef);
        TaxiHelper.setSubagency((TaxiProduct)product, (EntityReference)agencyRef);
        EntityReference blankOwner = ((TaxiProductSettings)TaxiHelper.getSettings().getEntity()).getYandexTaxiProfile();
        product.setBlankOwner(blankOwner);
        TaxiHelper.setSupplier((TaxiProduct)product, (EntityReference)blankOwner);
        product.setSystemNumber(data.getProductNumber());
        if (cityRef != null) {
            product.setCity(cityRef);
            product.setCountry(DictHelper.getCountry((DictionaryReference)cityRef));
        }
        product.setFinishDate(data.getFinishDate());
        product.setSource(data.getSource());
        product.setDestination(data.getDestination());
        product.setCarClass(carClassRef);
        product.setFare(MoneyHelper.buildMoney((BigDecimal)data.getAmount(), (String)"RUB"));
        product.setEquivalentFare(product.getFare());
        VatValue vatValue = new VatValue();
        BigDecimal rate = DictHelper.getDefaultVat((Date)Optional.ofNullable(product.getFinishDate()).orElse(new Date()));
        vatValue.setRate(Double.valueOf(rate.doubleValue()));
        BigDecimal calculatedVatAmount = data.getAmount().multiply(rate).divide(BigDecimal.valueOf(120L), 2, RoundingMode.HALF_UP);
        if (!Objects.equals(calculatedVatAmount, data.getVatAmount())) {
            document.getMessages().add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u041d\u0414\u0421 \u0438\u0437 \u043e\u0431\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430 {0} \u043e\u0442\u043b\u0438\u0447\u0430\u0435\u0442\u0441\u044f \u043e\u0442 \u0440\u0430\u0441\u0441\u0447\u0438\u0442\u0430\u043d\u043d\u043e\u0433\u043e {1}, \u0434\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u041d\u0414\u0421 \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430", (Object[])new Object[]{data.getVatAmount(), calculatedVatAmount}));
        }
        vatValue.setAmount(data.getVatAmount());
        product.setEquivalentFareVatValue(vatValue);
    }
}

