/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.yandexTaxi.ibus.registration;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.ExchangeFile;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.ProcessingStatus;
import com.gridnine.xtrip.common.parsers.model.RegistryParsingResult;
import com.gridnine.xtrip.common.parsers.model.RegistryRow;
import com.gridnine.xtrip.common.parsers.model.TransactionType;
import com.gridnine.xtrip.common.parsers.model.yandexTaxi.YandexTaxiExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.yandexTaxi.YandexTaxiProductData;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class YandexTaxiParserRegisterExchangeDocumentProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        RegistryParsingResult registry = (RegistryParsingResult)ctx.getObject((Enum)IBusParsersContextKeys.PARSED_REGISTRY);
        ExchangeFile exchangeFile = (ExchangeFile)ctx.getObject((Enum)IBusParsersContextKeys.EXCHANGE_FILE);
        ContentType contentType = (ContentType)ctx.getObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_CONTENT_TYPE);
        List rows = registry.getRows();
        rows.removeIf(row -> !StringUtils.isAlphanumeric((String)((String)row.getValue(16))));
        int idx = 1;
        DecimalFormat nf = new DecimalFormat("0000");
        for (RegistryRow row2 : rows) {
            YandexTaxiExchangeDocument document = new YandexTaxiExchangeDocument();
            YandexTaxiProductData data = new YandexTaxiProductData();
            ctx.clearMessages();
            data.setProductNumber((String)this.verifyNonNull(row2.getValue(16), "\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043a\u0430\u0437\u0430", document.getMessages()));
            SimpleDateFormat fmt = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            try {
                data.setIssueDate(fmt.parse(String.format("%s %s", row2.getValue(0), row2.getValue(1))));
            }
            catch (ParseException ex) {
                document.getMessages().add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0434\u043b\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 {0} \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0434\u0430\u0442\u0443 \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f", (Object[])new Object[]{data.getProductNumber()}));
            }
            data.setAgentName((String)row2.getValue(6));
            data.setAgentPhoneNumber(this.normalizePhone((String)row2.getValue(11)));
            data.setAgentEmail((String)row2.getValue(12));
            data.setTravellerName((String)row2.getValue(6));
            data.setTravellerPhoneNumber(this.normalizePhone((String)row2.getValue(11)));
            data.setCity(this.normalizeCity((String)row2.getValue(17)));
            data.setSource((String)row2.getValue(18));
            data.setDestination((String)row2.getValue(20));
            try {
                data.setFinishDate(fmt.parse((String)row2.getValue(26)));
            }
            catch (ParseException ex) {
                document.getMessages().add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0434\u043b\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 {0} \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0434\u0430\u0442\u0443 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f \u043f\u043e\u0435\u0437\u0434\u043a\u0438", (Object[])new Object[]{data.getProductNumber()}));
            }
            data.setCarClass((String)row2.getValue(27));
            data.setComments((String)row2.getValue(29));
            data.setVatAmount((BigDecimal)this.verifyNonNull(row2.getValue(38), "\u041d\u0414\u0421", document.getMessages()));
            if (data.getVatAmount() != null) {
                data.setVatAmount(data.getVatAmount().setScale(2, RoundingMode.HALF_UP));
            }
            data.setAmount((BigDecimal)this.verifyNonNull(row2.getValue(39), "\u0421\u0443\u043c\u043c\u0430 \u0441 \u041d\u0414\u0421", document.getMessages()));
            if (data.getAmount() != null) {
                data.setAmount(data.getAmount().setScale(2, RoundingMode.HALF_UP));
            }
            data.setTransactionType(TransactionType.SELL);
            document.setProduct(data);
            document.setCreated(new Date());
            document.setLocation(exchangeFile.getLocation() + '|' + nf.format(idx++));
            document.setType(exchangeFile.getType());
            document.setContent(exchangeFile.getContent());
            document.setContentType(contentType);
            this.setDocumentStatus(document);
            ctx.addMessages((Collection)document.getMessages());
            EntityContainer container = EntityContainer.create((BaseEntity)document);
            container.setCreated(new Date());
            container.setModified(new Date());
            container.getVersionInfo().setDataSource("exchange-file-registration");
            EntityStorage.get().save(container, true);
        }
    }

    private void setDocumentStatus(YandexTaxiExchangeDocument document) {
        document.setStatus(ProcessingStatus.UNPROCESSED);
        if (MessageHelper.hasWarningMessages((Iterable)document.getMessages())) {
            document.setStatus(ProcessingStatus.WARNING);
        }
        if (MessagesHelper.hasErrorMessage((Iterable)document.getMessages())) {
            document.setStatus(ProcessingStatus.ERROR);
        }
    }

    private <T> T verifyNonNull(T obj, String fieldName, List<Message> messages) {
        if (obj == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u043f\u043e\u043b\u0435 '{0}'", (Object[])new Object[]{fieldName}));
        }
        return obj;
    }

    private String normalizePhone(String phone) {
        if (phone == null || phone.length() < 6) {
            return phone;
        }
        return String.format("%s (%s) %s", phone.substring(0, 2), phone.substring(2, 5), phone.substring(5));
    }

    private String normalizeCity(String city) {
        return city.replace('\u0451', '\u0435').replace('\u0401', '\u0415');
    }
}

