/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg;

import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.pg.platron.BasePaymentGateConfiguration;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PGHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePgSettingsProvider<T extends BasePaymentGateConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(BasePgSettingsProvider.class);

    public T get() {
        EntityContainer<T> result = this.loadSettingFromDb();
        if (result != null) {
            return (T)((BasePaymentGateConfiguration)result.getEntity());
        }
        return this.createSettings();
    }

    protected abstract String getPgSettingsUid();

    protected abstract Class<T> getSettingsClass();

    protected abstract void setDefaultProperties(T var1);

    protected abstract PgName getPgName();

    private T createSettings() {
        log.warn("Create unregistered settings {}", (Object)this.getSettingsClass().getName());
        try {
            return (T)((BasePaymentGateConfiguration)LockUtil.lock((String)this.getPgSettingsUid(), () -> {
                EntityContainer<T> result = this.loadSettingFromDb();
                if (result != null) {
                    return (BasePaymentGateConfiguration)result.getEntity();
                }
                T newConfig = this.loadFromFileOrCreateDefault();
                newConfig.setType(SystemSettingsType.PG_CONFIGURATION);
                newConfig.setPgName(this.getPgName());
                this.saveSettings(newConfig);
                return newConfig;
            }));
        }
        catch (Exception e) {
            log.error("createSettings error", (Throwable)e);
            throw new PGException("Couldn't get pg settings");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private T loadFromFileOrCreateDefault() throws IllegalAccessException, InstantiationException, IOException {
        File file = this.getConfigurationFile();
        if (!file.exists()) return this.createDefaultSettings();
        Properties config = new Properties();
        try (FileInputStream inputStream = new FileInputStream(file);){
            config.load(inputStream);
            T t = this.createSettingsFromProperties(config);
            return t;
        }
        catch (Exception e) {
            log.error("failed loading configuration from file " + file, (Throwable)e);
            throw e;
        }
    }

    protected File getConfigurationFile() {
        return PGHelper.getConfigurationFile(this.getPgName(), false);
    }

    private T createDefaultSettings() throws IllegalAccessException, InstantiationException {
        BasePaymentGateConfiguration settings = (BasePaymentGateConfiguration)this.getSettingsClass().newInstance();
        this.setDefaultProperties(settings);
        settings.setType(SystemSettingsType.PG_CONFIGURATION);
        return (T)settings;
    }

    protected T createSettingsFromProperties(Properties properties) throws InstantiationException, IllegalAccessException {
        T settings = this.createDefaultSettings();
        return settings;
    }

    private void saveSettings(T newConfig) {
        EntityContainer container = EntityContainer.create(newConfig);
        container.setUid(this.getPgSettingsUid());
        container.setCreatedBy("system");
        container.getVersionInfo().setCreatedBy("system");
        container.getVersionInfo().setDataSource("pg-settings-provider");
        container.getVersionInfo().setVersionNotes("create settings");
        EntityStorage.get().save(container, true);
    }

    private EntityContainer<T> loadSettingFromDb() {
        return EntityStorage.get().resolve(this.createSettingsReference());
    }

    private EntityReference<T> createSettingsReference() {
        return new EntityReference(this.getPgSettingsUid(), this.getSettingsClass(), null);
    }
}

