/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.BillingTransaction;
import com.gridnine.xtrip.common.model.system.BillingTransactionCategory;
import com.gridnine.xtrip.common.model.system.BillingTransactionIndex;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.common.model.system.BillingTransactionType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.helpers.BillingTransactionQueryBuilder;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class BillingTransactionQueryBuilderTest
extends ModelTestBase {
    @Test
    public void testQuery() {
        Assert.assertThat((Object)this.getCount(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0)));
        BillingTransaction result = new BillingTransaction();
        result.setCategory(BillingTransactionCategory.DEBIT);
        result.setPaymentType(PaymentType.CASH);
        result.setSum(SystemHelper.getMoney((double)10.0, (String)"RUB"));
        result.setEntity(null);
        result.setType(BillingTransactionType.BILLING);
        result.setContractType(ContractType.VENDOR);
        result.setStatus(BillingTransactionStatus.ACTIVE);
        EntityStorage.get().save(EntityContainer.create((BaseEntity)result), false);
        Assert.assertThat((Object)this.getCount(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1)));
    }

    private int getCount() {
        SearchQuery query = new BillingTransactionQueryBuilder().withCategory(BillingTransactionCategory.DEBIT).withPaymentType(PaymentType.CASH).withType(BillingTransactionType.BILLING).withContractType(ContractType.VENDOR).withStatus(BillingTransactionStatus.ACTIVE).withResultMode(ResultMode.COUNT_ONLY).getInstance();
        return EntityStorage.get().search(BillingTransactionIndex.class, query).getTotalCount();
    }
}

