/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg;

import com.gridnine.bof.midoffice.helper.MidofficeHelper;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentHelper;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductFop;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AeroexpressTicketHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.pg.SplitPaymentRegistry;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.handlers.CustomProductFopsHandler;
import com.gridnine.xtrip.server.pg.handlers.PgHandlersRegistry;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Objects;

public class CreateFopsHandler {
    private boolean isSplitPayment;
    protected EntityContainer<BookingFile> bookingFile;
    protected Payment payment;

    public CreateFopsHandler() {
    }

    public CreateFopsHandler(EntityContainer<BookingFile> bookingFileCtr, Payment payment) throws NullPointerException {
        this.prepare(bookingFileCtr, payment);
    }

    public CreateFopsHandler prepare(EntityContainer<BookingFile> bookingFileCtr, Payment payment) throws NullPointerException {
        Objects.requireNonNull(payment.getPg());
        this.bookingFile = bookingFileCtr;
        this.payment = payment;
        this.isSplitPayment = this.getSplitPaymentRegistry().isSplitPayment(payment.getPaymentType());
        return this;
    }

    public void processAndSave() throws Exception {
        this.createDefaultFops();
        this.updateBookingFileFopTypes();
        this.saveBookingFile();
    }

    private void updateBookingFileFopTypes() {
        PgHandlersRegistry.getUpdateFopTypeHandler().ifPresent(handler -> handler.update(this.bookingFile, this.payment.getPaymentType(), null, this.payment.getDetails()));
    }

    protected void createDefaultFops() throws Exception {
        for (Reservation reservation : MidofficeHelper.getReservations(this.bookingFile, PaymentHelper.getReservations((BookingFile)this.bookingFile.getEntity(), (Collection<String>)this.payment.getReservations()))) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                if (baseProduct instanceof Product) {
                    this.createAirProductFops(baseProduct);
                    continue;
                }
                if (baseProduct instanceof AeroexpressTicket) {
                    this.createAeroExpressFops(baseProduct);
                    continue;
                }
                if (baseProduct instanceof InsuranceAccident) {
                    this.createInsuranceAccidentFops(baseProduct);
                    continue;
                }
                if (baseProduct instanceof HotelProduct) {
                    this.createHotelFops(baseProduct);
                    continue;
                }
                this.createFopsForCustomProduct(baseProduct);
            }
        }
    }

    protected void saveBookingFile() {
        VersionInfo versionInfo = this.bookingFile.getVersionInfo();
        versionInfo.setVersionNotes("createFops");
        versionInfo.setDataSource("payment-" + this.payment.getPg().name());
        EntityStorage.get().save(this.bookingFile, true);
    }

    private void createHotelFops(BaseProduct baseProduct) throws Exception {
        BigDecimal price = PaymentHelper.calculateProductPrice(baseProduct, null);
        HotelProductFop fop = new HotelProductFop();
        fop.setEquivalentAmount(BigDecimal.ZERO);
        Money money = new Money();
        money.setCurrency(DictHelper.getLocalCurrency());
        money.setValue(price);
        fop.setAmount(money);
        fop.setOperationDate(new Date());
        fop.setType(this.payment.getPaymentType());
        fop.setCard(PaymentHelper.convertCardDetailsToCard(this.payment.getDetails()));
        HotelProduct prod = (HotelProduct)baseProduct;
        for (HotelProductContractRelationData relation : HotelProductHelper.getContractRelations((HotelProduct)prod)) {
            ContractType relationContractType = GeneralProductHelper.getContractType((EntityReference)relation.getDescription());
            relation.getFops().clear();
            switch (relationContractType) {
                case VENDOR: {
                    HotelProductFop newFop = (HotelProductFop)XCloneHelper.clone((XCloneable)fop, (boolean)true);
                    newFop.setType(this.payment.getPaymentType());
                    relation.getFops().add(newFop);
                    break;
                }
                case CLIENT: {
                    relation.getFops().add(fop);
                    break;
                }
                case SUBAGENCY: {
                    relation.getFops().add(XCloneHelper.clone((XCloneable)fop, (boolean)true));
                }
            }
        }
        prod.setContractRulesApplied(false);
    }

    private void clearHotelCommissions(HotelProductContractRelationData relation, ContractType contractType) {
        if (contractType == ContractType.VENDOR) {
            this.clearHotelVendorCommissions(relation);
            return;
        }
        relation.getCommissions().clear();
    }

    private void clearHotelVendorCommissions(HotelProductContractRelationData relation) {
        Iterator iterator = relation.getCommissions().iterator();
        while (iterator.hasNext()) {
            GeneralProductCommission commission = (GeneralProductCommission)iterator.next();
            if (HotelProductHelper.isVendorCommissionProperties((EntityReference)commission.getCommissionProperties())) continue;
            iterator.remove();
        }
    }

    protected void createInsuranceAccidentFops(BaseProduct baseProduct) throws Exception {
        if (this.isSplitPayment) {
            this.createInsuranceAccidentSplitFops(baseProduct);
            return;
        }
        BigDecimal price = PaymentHelper.calculateProductPrice(baseProduct, null);
        GeneralProductFop fop = new GeneralProductFop();
        fop.setEquivalentAmount(price);
        fop.setOperationDate(new Date());
        fop.setType(this.payment.getPaymentType());
        fop.setCard(PaymentHelper.convertCardDetailsToCard(this.payment.getDetails()));
        InsuranceAccident prod = (InsuranceAccident)baseProduct;
        for (GeneralProductContractRelationData relation : InsuranceAccidentHelper.getContractRelations((InsuranceAccident)prod)) {
            relation.getFops().clear();
            switch (GeneralProductHelper.getContractType((EntityReference)relation.getDescription())) {
                case VENDOR: {
                    GeneralProductFop fop1 = (GeneralProductFop)XCloneHelper.clone((XCloneable)fop, (boolean)true);
                    fop1.setType(this.payment.getPaymentType());
                    relation.getFops().add(fop1);
                    break;
                }
                case CLIENT: {
                    relation.getFops().add(fop);
                    break;
                }
                case SUBAGENCY: {
                    relation.getFops().add(XCloneHelper.clone((XCloneable)fop, (boolean)true));
                }
            }
        }
        prod.setContractRulesApplied(false);
    }

    protected void createAeroExpressFops(BaseProduct bp) throws Exception {
        if (this.isSplitPayment) {
            this.createAeroExpressSplitFops(bp);
            return;
        }
        GeneralProductFop fop = new GeneralProductFop();
        BigDecimal price = PaymentHelper.calculateProductPrice(bp, null);
        fop.setEquivalentAmount(price);
        fop.setOperationDate(new Date());
        fop.setType(this.payment.getPaymentType());
        fop.setCard(PaymentHelper.convertCardDetailsToCard(this.payment.getDetails()));
        AeroexpressTicket prod = (AeroexpressTicket)bp;
        for (GeneralProductContractRelationData item : AeroexpressTicketHelper.getContractRelations((AeroexpressTicket)prod)) {
            item.getFops().clear();
            switch (GeneralProductHelper.getContractType((EntityReference)item.getDescription())) {
                case CLIENT: {
                    item.getFops().add(fop);
                    break;
                }
                case SUBAGENCY: {
                    item.getFops().add(XCloneHelper.clone((XCloneable)fop, (boolean)true));
                    break;
                }
                case VENDOR: {
                    GeneralProductFop fop1 = (GeneralProductFop)XCloneHelper.clone((XCloneable)fop, (boolean)true);
                    fop1.setType(this.payment.getPaymentType());
                    item.getFops().add(fop1);
                }
            }
        }
        prod.setContractRulesApplied(false);
    }

    protected void createAirProductFops(BaseProduct baseProduct) throws Exception {
        if (this.isSplitPayment) {
            this.createAirProductSplitFops(baseProduct);
            return;
        }
        BigDecimal price = PaymentHelper.calculateProductPrice(baseProduct, null);
        Money m = new Money();
        m.setCurrency(DictHelper.getLocalCurrency());
        m.setValue(price);
        ProductFop fop = new ProductFop();
        fop.setAmount(m);
        fop.setOperationDate(new Date());
        fop.setType(this.payment.getPaymentType());
        fop.setCard(PaymentHelper.convertCardDetailsToCard(this.payment.getDetails()));
        Product airProduct = (Product)baseProduct;
        AirProductHelper.clearFops((Product)airProduct);
        for (AirProductContractRelationData relation : AirProductHelper.getContractRelations((Product)airProduct)) {
            switch (GeneralProductHelper.getContractType((EntityReference)relation.getDescription())) {
                case VENDOR: {
                    ProductFop fop1 = (ProductFop)XCloneHelper.clone((XCloneable)fop, (boolean)true);
                    relation.getFops().add(fop1);
                    break;
                }
                case CLIENT: {
                    relation.getFops().add(fop);
                    break;
                }
                case SUBAGENCY: {
                    relation.getFops().add(XCloneHelper.clone((XCloneable)fop, (boolean)true));
                }
            }
        }
        airProduct.setContractRulesApplied(false);
    }

    private SplitPaymentRegistry getSplitPaymentRegistry() {
        return (SplitPaymentRegistry)Environment.getPublished(SplitPaymentRegistry.class);
    }

    protected void createAirProductSplitFops(BaseProduct bp) throws Exception {
        Product prod = (Product)bp;
        BigDecimal price = AirProductHelper.getTotalEquivalentFare((Product)prod);
        ProductFop priceFop = new ProductFop();
        priceFop.setAmount(SystemHelper.getMoney((double)price.doubleValue(), (String)DictHelper.getEquivCurrency()));
        priceFop.setOperationDate(new Date());
        priceFop.setType((PaymentType)this.getSplitPaymentRegistry().getSupplierPaymentType(this.payment.getPaymentType()).get());
        priceFop.setCard(PaymentHelper.convertCardDetailsToCard(this.payment.getDetails()));
        AirProductHelper.clearFops((Product)prod);
        for (AirProductContractRelationData relation : AirProductHelper.getContractRelations((Product)prod)) {
            switch (GeneralProductHelper.getContractType((EntityReference)relation.getDescription())) {
                case VENDOR: 
                case SUBAGENCY: {
                    relation.getFops().add(XCloneHelper.clone((XCloneable)priceFop, (boolean)true));
                    break;
                }
                case CLIENT: {
                    relation.getFops().add(priceFop);
                }
            }
        }
        AirProductHelper.clearCommissions((Product)prod);
        prod.setContractRulesApplied(false);
    }

    protected void createInsuranceAccidentSplitFops(BaseProduct baseProduct) throws Exception {
        InsuranceAccident prod = (InsuranceAccident)baseProduct;
        ProductHandler handler = HandlersRegistry.get().findProductHandler(InsuranceAccident.class);
        BigDecimal price = handler.getEquivalentFare((BaseProduct)prod);
        GeneralProductFop priceFop = new GeneralProductFop();
        priceFop.setEquivalentAmount(price);
        priceFop.setOperationDate(new Date());
        priceFop.setType((PaymentType)this.getSplitPaymentRegistry().getAgencyPaymentType(this.payment.getPaymentType()).get());
        priceFop.setCard(PaymentHelper.convertCardDetailsToCard(this.payment.getDetails()));
        for (GeneralProductContractRelationData relation : InsuranceAccidentHelper.getContractRelations((InsuranceAccident)prod)) {
            relation.getFops().clear();
            switch (GeneralProductHelper.getContractType((EntityReference)relation.getDescription())) {
                case VENDOR: 
                case SUBAGENCY: {
                    relation.getFops().add(XCloneHelper.clone((XCloneable)priceFop, (boolean)true));
                    break;
                }
                case CLIENT: {
                    relation.getFops().add(priceFop);
                }
            }
        }
        prod.setContractRulesApplied(false);
    }

    protected void createAeroExpressSplitFops(BaseProduct bp) throws Exception {
        AeroexpressTicket ticket = (AeroexpressTicket)bp;
        ProductHandler handler = HandlersRegistry.get().findProductHandler(AeroexpressTicket.class);
        BigDecimal price = handler.getEquivalentFare((BaseProduct)ticket);
        BigDecimal penalty = handler.getPenalty((BaseProduct)ticket);
        if (penalty != null) {
            price = handler.getStatus((BaseProduct)ticket) == ProductStatus.EXCHANGE || handler.getStatus((BaseProduct)ticket) == ProductStatus.REFUND ? price.subtract(penalty) : price.add(penalty);
        }
        GeneralProductFop priceFop = new GeneralProductFop();
        priceFop.setEquivalentAmount(price);
        priceFop.setOperationDate(new Date());
        priceFop.setType((PaymentType)this.getSplitPaymentRegistry().getAgencyPaymentType(this.payment.getPaymentType()).get());
        priceFop.setCard(PaymentHelper.convertCardDetailsToCard(this.payment.getDetails()));
        for (GeneralProductContractRelationData item : AeroexpressTicketHelper.getContractRelations((AeroexpressTicket)ticket)) {
            item.getFops().clear();
            switch (GeneralProductHelper.getContractType((EntityReference)item.getDescription())) {
                case VENDOR: 
                case SUBAGENCY: {
                    item.getFops().add(XCloneHelper.clone((XCloneable)priceFop, (boolean)true));
                    break;
                }
                case CLIENT: {
                    item.getFops().add(priceFop);
                }
            }
        }
        ticket.setContractRulesApplied(false);
    }

    private boolean createFopsForCustomProduct(BaseProduct baseProduct) throws Exception {
        CustomProductFopsHandler customProductFopsHandler = ((PgHandlersRegistry)Environment.getPublished(PgHandlersRegistry.class)).getCustomProductFopHandler();
        if (customProductFopsHandler != null) {
            return customProductFopsHandler.createCustomProductFops(baseProduct, this.isSplitPayment ? (PaymentType)this.getSplitPaymentRegistry().getAgencyPaymentType(this.payment.getPaymentType()).get() : this.payment.getPaymentType(), this.payment.getDetails());
        }
        return false;
    }
}

