/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.RepricePaymentHandler;
import java.util.Collection;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRepricePaymentHandler
implements RepricePaymentHandler {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean updatePayment;

    @Override
    public RepricePaymentHandler updatePayment(boolean updatePayment) {
        this.updatePayment = updatePayment;
        return this;
    }

    @Override
    public void reprice(Payment payment) {
        EntityContainer<BookingFile> bookingFile = this.executeReprice(payment);
        if (this.updatePayment) {
            this.updatePaymentAmounts(payment, bookingFile);
        }
    }

    private EntityContainer<BookingFile> executeReprice(Payment payment) {
        EntityReference bookingFileRef = payment.getEntity();
        EntityContainer bookingFileCtr = EntityStorageHelper.resolve((EntityReference)bookingFileRef);
        Reservation reservation = BookingHelper.getBaseProductReservation((BookingFile)((BookingFile)bookingFileCtr.getEntity()), (boolean)true);
        SalesContext salesContext = SalesContextHandler.get().createSalesContext(reservation);
        Fop fop = PaymentHelper.createFop(payment);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(IBusMidofficeContextKeys.BOOKING_FILE.name(), bookingFileCtr);
        Collection<Reservation> reservations = PaymentHelper.getReservations((BookingFile)bookingFileCtr.getEntity(), (Collection<String>)payment.getReservations());
        if (reservations != null) {
            data.put(IBusMidofficeContextKeys.BOOKING_FILE_RESERVATIONS.name(), reservations);
        }
        data.put(IBusMidofficeContextKeys.SALES_CONTEXT.name(), salesContext);
        data.put(IBusMidofficeContextKeys.FOP.name(), fop);
        IntegrationBusFacade.get().getRequestReplyAdapter("midoffice:reprice-booking").processSync(data);
        bookingFileCtr = (EntityContainer)data.get(IBusMidofficeContextKeys.BOOKING_FILE.name());
        return bookingFileCtr;
    }

    private void updatePaymentAmounts(Payment payment, EntityContainer<BookingFile> bookingFile) {
        payment.setEntity(bookingFile.toReference());
        try {
            payment.setAmount(PaymentHelper.getTotalPrices(bookingFile, PaymentHelper.getReservations((BookingFile)bookingFile.getEntity(), (Collection<String>)payment.getReservations()), ContractType.CLIENT).get(payment.getPaymentType()));
        }
        catch (Exception e) {
            this.log.error("Could not update total price in payment", (Throwable)e);
        }
        payment.setFee(PaymentHelper.getTotalFee((BookingFile)bookingFile.getEntity(), ContractType.CLIENT));
    }
}

