/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.commission.CalculationType;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeType;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeCalculationBasis;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeType;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.CommissionCategoryReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.pg.SplitPaymentRegistry;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.GeneralProductActions;
import com.gridnine.xtrip.common.model.rules.standard.MidofficeActions;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.helper.AllowedPaymentTypesHandler;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GetTotalPricesTest
extends ModelTestBase {
    private EntityReference<PaymentFeeProperties> raifisenFee;
    private EntityReference<PaymentFeeProperties> rapidaFee;
    private EntityReference<FeeProperties> ticketFee;
    private EntityReference<FeeProperties> deliveryFee;
    private final EntityReference<Organization> agencyRef = new EntityReference("test_agency_container_uid", Organization.class, "Test Agency");
    private final EntityReference<Organization> clientRef = new EntityReference("retail_profile_container", Organization.class, "Retail Client");
    private final EntityReference<Organization> blankOwnerRef = new EntityReference("BSP_container", Organization.class, "BSP");

    @Before
    public void before() {
        AllowedPaymentTypesHandler allowedHandler = (AllowedPaymentTypesHandler)EasyMock.mock(AllowedPaymentTypesHandler.class);
        Environment.publish(AllowedPaymentTypesHandler.class, (Object)allowedHandler);
        SplitPaymentRegistry mock = (SplitPaymentRegistry)EasyMock.mock(SplitPaymentRegistry.class);
        EasyMock.expect((Object)mock.isSplitOrSupplierPaymentType((PaymentType)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.expect((Object)mock.isSplitPayment((PaymentType)EasyMock.anyObject())).andReturn((Object)false).anyTimes();
        EasyMock.expect(allowedHandler.getAllowedPaymentTypes((EntityContainer<BookingFile>)((EntityContainer)EasyMock.anyObject()))).andReturn(new HashSet<PaymentType>(Arrays.asList(PaymentType.CREDIT_CARD_ONLINE_RAIFFEISEN, PaymentType.INVOICE_RAPIDA, PaymentType.CASH_DELIVERY))).anyTimes();
        EasyMock.replay((Object[])new Object[]{mock, allowedHandler});
        Environment.publish(SplitPaymentRegistry.class, (Object)mock);
    }

    @Test
    public void testGetTotalPrices() throws Exception {
        this.createProfiles();
        EntityContainer<BookingFile> bookingCtr = this.createBooking();
        Map<PaymentType, BigDecimal> totalPrices = PaymentHelper.getTotalPrices(bookingCtr, ContractType.CLIENT);
        Assert.assertThat((Object)totalPrices.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)3)));
        block5: for (Map.Entry<PaymentType, BigDecimal> entry : totalPrices.entrySet()) {
            switch (entry.getKey()) {
                case CREDIT_CARD_ONLINE_RAIFFEISEN: {
                    Assert.assertEquals((double)405.0, (double)entry.getValue().doubleValue(), (double)0.001);
                    continue block5;
                }
                case INVOICE_RAPIDA: {
                    Assert.assertEquals((double)415.0, (double)entry.getValue().doubleValue(), (double)0.001);
                    continue block5;
                }
                case CASH_DELIVERY: {
                    Assert.assertEquals((double)500.0, (double)entry.getValue().doubleValue(), (double)0.001);
                    continue block5;
                }
            }
            Assert.fail((String)"unexpected payment type");
        }
    }

    private EntityContainer<BookingFile> createBooking() throws Exception {
        Airline carrier;
        EntityContainer bfc = new EntityContainer(BookingFile.class);
        BookingFile bf = (BookingFile)bfc.getEntity();
        Reservation reservation = new Reservation();
        bf.getReservations().add(reservation);
        reservation.setBookingFile(bf);
        Product product = new Product();
        reservation.getProducts().add(product);
        product.setReservation(reservation);
        bf.setCustomerProfile(this.clientRef);
        Traveller traveller = new Traveller();
        traveller.setName("Test Person");
        bf.getTravellers().add(traveller);
        product.setTraveller(traveller);
        product.setBlankOwnerRef(this.blankOwnerRef);
        EntityContainer ctr = EntityStorage.get().resolve(this.blankOwnerRef);
        if (ctr != null && ((Organization)ctr.getEntity()).getAirline() != null && (carrier = (Airline)DictionaryCache.get().resolveReference(((Organization)ctr.getEntity()).getAirline())) != null) {
            product.setBlankOwnerNumber(carrier.getAirlineNumber());
        }
        product.setStatus(ProductStatus.SELL);
        product.setCarrier((DictionaryReference)new AirlineReference("SU"));
        bf.setAgency(this.agencyRef);
        AirProductHelper.setSubagency((Product)product, this.agencyRef);
        AirProductHelper.setAgency((Product)product, this.agencyRef);
        AirProductHelper.setSupplier((Product)product, this.blankOwnerRef);
        product.setProductCategory(ProductCategory.AIR);
        product.setEticket(true);
        product.setBlankType((DictionaryReference)new BlankTypeReference("BSP ETKT"));
        Money money = new Money();
        money.setCurrency("RUB");
        money.setValue(BigDecimal.valueOf(100L));
        AirProductHelper.setBaseFare((Product)product, (Money)money);
        AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)BigDecimal.valueOf(100L));
        Tax tax = new Tax();
        tax.setCode("RU");
        tax.setEquivalentAmount(BigDecimal.valueOf(100L));
        product.getTaxes().add(tax);
        product.setStatus(ProductStatus.SELL);
        product.setIssueDate(new Date());
        product.setCarrierNumber("555");
        ProductFop vendorFop = new ProductFop();
        vendorFop.setType(PaymentType.CASH);
        Segment segment = new Segment();
        segment.setRecordNumber(1);
        segment.setStartDate(product.getIssueDate());
        segment.setAirline(product.getCarrier());
        segment.setDepartureLocation((DictionaryReference)new GeoLocationReference("MOW"));
        segment.setArriveLocation((DictionaryReference)new GeoLocationReference("KJA"));
        segment.setFareBasis("farebasis");
        SegmentTariff sppPsgr = new SegmentTariff();
        sppPsgr.getSegments().add(segment);
        product.getSegmentTariffs().add(sppPsgr);
        Money money2 = new Money();
        money2.setCurrency("RUB");
        money2.setValue(BigDecimal.valueOf(200L));
        vendorFop.setAmount(money2);
        for (AirProductContractRelationData relation : AirProductHelper.getContractRelations((Product)product)) {
            if (GeneralProductHelper.getContractType((EntityReference)relation.getDescription()) == ContractType.VENDOR) {
                relation.getFops().add(vendorFop);
                continue;
            }
            ProductFop clonedFop = (ProductFop)XCloneHelper.clone((XCloneable)vendorFop, (boolean)true);
            clonedFop.setOperationDate(product.getIssueDate());
            relation.getFops().add(clonedFop);
        }
        EntityStorage.get().save(bfc, false);
        return bfc;
    }

    private void createProfiles() {
        EntityContainer ctr = new EntityContainer(PaymentFeeProperties.class);
        PaymentFeeProperties properties = (PaymentFeeProperties)ctr.getEntity();
        properties.setBasis(PaymentFeeCalculationBasis.TRANSACTION);
        properties.setDisplayName("\u0418\u043d\u0432\u043e\u0439\u0441 (\u0420\u0430\u043f\u0438\u0434\u0430), %");
        properties.setChargeOnRefund(false);
        properties.setPaymentType(PaymentType.INVOICE_RAPIDA);
        properties.setRate(true);
        properties.setRoundingMode(RoundingMode.UP);
        properties.setRoundingValue(RoundingValue.V_1);
        properties.setType(PaymentFeeType.STANDARD);
        this.rapidaFee = ctr.toReference();
        EntityStorage.get().save(ctr, true);
        ctr = new EntityContainer(PaymentFeeProperties.class);
        properties = (PaymentFeeProperties)ctr.getEntity();
        properties.setBasis(PaymentFeeCalculationBasis.PRICE);
        properties.setDisplayName("\u041a\u0440\u0435\u0434\u0438\u0442\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u0430 online (Raiffeisen), %");
        properties.setChargeOnRefund(false);
        properties.setPaymentType(PaymentType.CREDIT_CARD_ONLINE_RAIFFEISEN);
        properties.setRate(true);
        properties.setRoundingMode(RoundingMode.UP);
        properties.setRoundingValue(RoundingValue.V_1);
        properties.setType(PaymentFeeType.STANDARD);
        this.raifisenFee = ctr.toReference();
        EntityStorage.get().save(ctr, true);
        ctr = new EntityContainer(FeeProperties.class);
        properties = (FeeProperties)ctr.getEntity();
        properties.setCalculationType(CalculationType.TICKET);
        properties.setCategory((DictionaryReference)new CommissionCategoryReference("cat"));
        properties.setOperation(Operation.SELL);
        properties.setDisplayName("\u041f\u0440\u043e\u0441\u0442\u043e\u0439 \u0441\u0431\u043e\u0440");
        properties.setRoundingMode(RoundingMode.NONE);
        properties.setType(FeeType.STANDARD);
        properties.getProductTypes().add(ProductType.AIR_TICKET);
        this.ticketFee = ctr.toReference();
        EntityStorage.get().save(ctr, true);
        ctr = new EntityContainer(FeeProperties.class);
        properties = (FeeProperties)ctr.getEntity();
        properties.setCalculationType(CalculationType.TICKET);
        properties.setCategory((DictionaryReference)new CommissionCategoryReference("cat"));
        properties.setOperation(Operation.SELL);
        properties.setDisplayName("\u0421\u0431\u043e\u0440 \u0437\u0430 \u0434\u043e\u0441\u0442\u0430\u0432\u043a\u0443");
        properties.setRoundingMode(RoundingMode.NONE);
        properties.setType(FeeType.STANDARD);
        properties.getProductTypes().add(ProductType.DELIVERY);
        this.deliveryFee = ctr.toReference();
        EntityStorage.get().save(ctr, true);
        EntityContainer cc = new EntityContainer(Contract.class);
        Contract contract = (Contract)cc.getEntity();
        ContractCustomerInfo info = new ContractCustomerInfo();
        contract.getCustomers().add(info);
        contract.setContractType(ContractType.CLIENT);
        contract.setSupplier(this.agencyRef);
        info.setCustomer(this.clientRef);
        info.setNumber("test contract");
        RuleSet rules = new RuleSet();
        RuleSettings rs = new RuleSettings();
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        rs.setName("allowed payment types");
        RuleResult res = new RuleResult();
        res.setAction((RuleAction)MidofficeActions.ALLOWED_PAYMENT_TYPES);
        res.setValue((Object)new PaymentType[]{PaymentType.CASH_DELIVERY, PaymentType.CREDIT_CARD_ONLINE_RAIFFEISEN, PaymentType.INVOICE_RAPIDA});
        rs.getResults().add(res);
        rules.getRules().add(rs);
        rs = new RuleSettings();
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        rs.setName("raiffesen fee");
        res = new RuleResult();
        res.setAction((RuleAction)Actions.PAYMENT_FEE);
        RuleResultValue value = new RuleResultValue();
        value.setCurrencyCode("%");
        value.setTarget(this.raifisenFee);
        value.setValue(2.5);
        res.setValue((Object)value);
        rs.getResults().add(res);
        rules.getRules().add(rs);
        rs = new RuleSettings();
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        rs.setName("rapida fee");
        res = new RuleResult();
        res.setAction((RuleAction)Actions.PAYMENT_FEE);
        value = new RuleResultValue();
        value.setCurrencyCode("%");
        value.setTarget(this.rapidaFee);
        value.setValue(3.5);
        res.setValue((Object)value);
        rs.getResults().add(res);
        rules.getRules().add(rs);
        rs = new RuleSettings();
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        rs.setName("ticket fee");
        res = new RuleResult();
        res.setAction((RuleAction)Actions.SIMPLE_FEE);
        value = new RuleResultValue();
        value.setCurrencyCode("RUB");
        value.setTarget(this.ticketFee);
        value.setValue(200.0);
        res.setValue((Object)value);
        rs.getResults().add(res);
        rules.getRules().add(rs);
        rs = new RuleSettings();
        rs.setTarget((RuleTarget)Targets.DELIVERY);
        rs.setName("ticket fee");
        res = new RuleResult();
        res.setAction((RuleAction)GeneralProductActions.GENERAL_FEE);
        value = new RuleResultValue();
        value.setCurrencyCode("RUB");
        value.setTarget(this.deliveryFee);
        value.setValue(100.0);
        res.setValue((Object)value);
        rs.getResults().add(res);
        rules.getRules().add(rs);
        contract.setRuleSet(rules);
        EntityStorage.get().save(cc, true);
    }
}

