/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg;

import com.gridnine.bof.midoffice.helper.MidofficeHelper;
import com.gridnine.xtrip.common.midoffice.helper.CodeTranslator;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.util.TranslitUtil;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LongRecordBuilder {
    private final CodeTranslator codeTranslator = new CodeTranslator(new String[]{CodeSystem.IATA.name(), CodeSystem.CRT.name()});
    private EntityStorage entityStorage = EntityStorage.get();
    private DateFormat dateFormat = new SimpleDateFormat("MMddyy");

    public String build(Payment payment) throws Exception {
        String iData = null;
        if (payment.getEntity() != null && BookingFile.class.equals((Object)payment.getEntity().getType())) {
            StringBuilder result = new StringBuilder("01");
            BookingFile bookFile = (BookingFile)this.entityStorage.resolve(payment.getEntity()).getEntity();
            Collection reservations = MidofficeHelper.getReservations((BookingFile)bookFile, PaymentHelper.getReservations(bookFile, (Collection<String>)payment.getReservations()));
            Product airProduct = this.findAirProduct(reservations);
            if (null == airProduct) {
                return null;
            }
            Organization agency = (Organization)this.entityStorage.resolve(AirProductHelper.getAgency((Product)airProduct)).getEntity();
            String agencyCode = TranslitUtil.cyr2lat((String)agency.getCode(), (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.US_DEPARTMENT_OF_STATE);
            if ((agencyCode = agencyCode.replaceAll(" ", "")).length() >= 8) {
                result.append(agencyCode.substring(0, 8));
            } else {
                result.append(agencyCode);
                for (int i = 0; i < 8 - agencyCode.length(); ++i) {
                    result.append('0');
                }
            }
            ArrayList<Segment> segmentList = new ArrayList<Segment>();
            for (SegmentTariff s : airProduct.getSegmentTariffs()) {
                for (Segment t : s.getSegments()) {
                    segmentList.add(t);
                }
            }
            if (segmentList.size() > 4) {
                int size = segmentList.size();
                for (int i = 1; i < size; ++i) {
                    segmentList.remove(1);
                    if (segmentList.size() == 4) break;
                }
            }
            this.addSegments(result, segmentList);
            result.append(' ');
            String ticketNumber = this.getIDataTicketNumber(airProduct);
            result.append(ticketNumber);
            result.append(this.dateFormat.format(((Segment)segmentList.get(0)).getStartDate()));
            result.append(TranslitUtil.cyr2lat((String)this.codeTranslator.getNativeCode(((Segment)segmentList.get(segmentList.size() - 1)).getDepartureLocation()), (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.US_DEPARTMENT_OF_STATE).substring(0, 3));
            String name = TranslitUtil.cyr2lat((String)(airProduct.getTraveller().getPassport().getLastName() + " " + airProduct.getTraveller().getPassport().getFirstName()), (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.US_DEPARTMENT_OF_STATE);
            if (name.length() >= 20) {
                result.append(name.substring(0, 20));
            } else {
                result.append(name);
                for (int i = 0; i < 20 - name.length(); ++i) {
                    result.append(' ');
                }
            }
            iData = result.toString();
        }
        return TranslitUtil.cyr2lat(iData, (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.US_DEPARTMENT_OF_STATE);
    }

    private void addSegments(StringBuilder result, List<Segment> segmentList) {
        for (Segment segment : segmentList) {
            result.append(TranslitUtil.cyr2lat((String)this.codeTranslator.getNativeCode(segment.getAirline()), (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.US_DEPARTMENT_OF_STATE)).substring(0, 2);
            result.append(segment.getClassOfSvcCode() == null ? " " : TranslitUtil.cyr2lat((String)segment.getClassOfSvcCode(), (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.SIRENA_SERVICE_CLASSES_RULES).substring(0, 1));
            result.append(' ');
            result.append(TranslitUtil.cyr2lat((String)this.codeTranslator.getNativeCode(segment.getArriveLocation()), (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.US_DEPARTMENT_OF_STATE).substring(0, 3));
        }
        for (int i = 0; i < 4 - segmentList.size(); ++i) {
            result.append("       ");
        }
    }

    private Product findAirProduct(Collection<Reservation> reservations) {
        return reservations.stream().flatMap(r -> r.getProducts().stream()).filter(p -> p instanceof Product && DictHelper.isAdultPassengerType((DictionaryReference)((Product)p).getPassengerType())).map(Product.class::cast).reduce((f, s) -> s).orElse(null);
    }

    private String getIDataTicketNumber(Product aviaTicket) {
        StringBuilder result = new StringBuilder();
        StringBuilder ticket = new StringBuilder();
        ticket.append(aviaTicket.getCarrierNumber());
        String ticketNumber = TranslitUtil.cyr2lat((String)aviaTicket.getSystemNumber(), (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.US_DEPARTMENT_OF_STATE);
        ticket.append(ticketNumber);
        if (CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)aviaTicket.getReservation()) == GdsName.SABRE) {
            ticket.append(Long.valueOf(ticketNumber) % 7L);
        } else {
            ticket.append("0");
        }
        if (ticket.length() >= 14) {
            result.append(ticket.substring(0, 14));
        } else {
            result.append((CharSequence)ticket);
            for (int i = 0; i < 14 - ticket.length(); ++i) {
                result.append(' ');
            }
        }
        return result.toString();
    }
}

