/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg;

import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.server.pg.PGLockManager;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MidofficePGLockManager
implements PGLockManager {
    private static Logger log = LoggerFactory.getLogger(MidofficePGLockManager.class);

    @Override
    public <T extends BaseEntity, E extends Exception, V> V underLock(EntityReference<T> ref, LockUtil.CallableWithParameterAndException<EntityContainer<T>, V, E> body) throws InterruptedException, E, TimeoutException {
        return (V)LockUtil.lock(ref, (long)20L, (TimeUnit)TimeUnit.MINUTES, body, () -> {
            log.warn("entityRef lock timeout");
            throw new TimeoutException();
        });
    }

    @Override
    public <V, E extends Exception> V underLock(PgName pgName, Class<?> lockerClass, String param, LockUtil.CallableWithException<V, E> body, TimeUnit timeUnit, long timeAmount) throws InterruptedException, E, TimeoutException {
        String lockKey = LockUtil.getLockKey((String)param, lockerClass, (String)pgName.name());
        return (V)LockUtil.lock((String)lockKey, (long)timeAmount, (TimeUnit)timeUnit, body, () -> {
            log.warn("param lock timeout exception, key=" + lockKey);
            throw new TimeoutException();
        });
    }
}

