/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg;

import com.gridnine.bof.midoffice.trace.Tracer;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.model.PGConnectorInfo;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentCheckParameters;
import com.gridnine.xtrip.common.pg.model.PaymentCheckResult;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.server.ServerApplication;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import com.gridnine.xtrip.server.pg.DefaultHandlersFactory;
import com.gridnine.xtrip.server.pg.DefaultPgParametersSupplier;
import com.gridnine.xtrip.server.pg.HandlersFactory;
import com.gridnine.xtrip.server.pg.IBusPgContextKeys;
import com.gridnine.xtrip.server.pg.PGConnectorRegistry;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PGHelper;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.PaymentProcessing;
import com.gridnine.xtrip.server.pg.PaymentQueueManager;
import com.gridnine.xtrip.server.pg.PaymentSucceedHandler;
import com.gridnine.xtrip.server.pg.PgParametersSupplier;
import com.gridnine.xtrip.server.pg.PgSysLogItem;
import com.gridnine.xtrip.server.pg.PgTotalPriceProvider;
import com.gridnine.xtrip.server.pg.handlers.PaymentStatusHandler;
import com.gridnine.xtrip.server.pg.handlers.PgHandlersRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PGConnector
implements PaymentProcessing {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private PaymentQueueManager paymentQueueManager;
    private boolean enabled;
    private Properties config;
    private PgParametersSupplier pgParametersSupplier = new DefaultPgParametersSupplier();
    protected HandlersFactory handlerFactory = new DefaultHandlersFactory();

    public PGConnector() {
        this.paymentQueueManager = new PaymentQueueManager(this.getId());
    }

    public PGConnector(PgName pgName) {
        this.paymentQueueManager = new PaymentQueueManager(pgName);
    }

    public static void auditMessage(EntityReference<BaseEntity> entityReference, Message message, String tag) {
        if (message != null) {
            SysLogHelper.audit(entityReference, (String)tag, (Message[])new Message[]{message});
        }
    }

    public static void auditMessage(EntityReference<? extends BaseEntity> entityReference, PgSysLogItem item) {
        SysLogHelper.audit(entityReference, (String)item.getTag(), (Message[])new Message[]{item.toMessage()});
    }

    public static boolean hasErrors(List<Message> messages) {
        for (Message msg : messages) {
            if (msg.getType() != MessageType.ERROR) continue;
            return true;
        }
        return false;
    }

    public synchronized void setHandlerFactory(HandlersFactory handlerFactory) {
        this.handlerFactory = handlerFactory;
    }

    public PaymentQueueManager getQueueManager() {
        return this.paymentQueueManager;
    }

    public void setQueueManager(PaymentQueueManager paymentQueueManager) {
        this.paymentQueueManager = paymentQueueManager;
    }

    public abstract PgName getId();

    public PgParametersSupplier getPgParametersSupplier() {
        return this.pgParametersSupplier;
    }

    public void setPgParametersSupplier(PgParametersSupplier pgParametersSupplier) {
        this.pgParametersSupplier = pgParametersSupplier;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public NamedLock getLock(String id) throws Exception {
        String lockName = String.format("CLASS:%s,UID:%s,TAG:%s", this.getClass().getName(), String.valueOf(id), String.valueOf(this.getId()));
        return LockUtil.getLockManager().getLock((Object)lockName);
    }

    public Properties getConfiguration() {
        if (this.config != null) {
            return this.config;
        }
        File file = PGHelper.getConfigurationFile(this.getId(), false);
        this.config = new Properties();
        if (file.isFile()) {
            try (FileInputStream strm = new FileInputStream(file);){
                this.config.load(strm);
            }
            catch (Exception e) {
                this.log.error("failed loading configuration from file " + file, (Throwable)e);
            }
        } else {
            this.log.warn("configuration file not found " + file);
        }
        return this.config;
    }

    public void addToQueue(Payment payment) throws Exception {
        this.getQueueManager().addToQueue(payment);
    }

    public void updateToQueue(Payment payment) throws Exception {
        this.getQueueManager().updateToQueue(payment);
    }

    public void removeFromQueue(String paymentId) throws Exception {
        this.getQueueManager().removeFromQueue(paymentId);
    }

    public void removeFromQueue(Payment payment) throws Exception {
        this.getQueueManager().removeFromQueue(payment);
    }

    public Payment getFromQueue(String paymentId) throws Exception {
        return this.getQueueManager().getFromQueue(paymentId);
    }

    public ContractType getContractType() {
        return ContractType.CLIENT;
    }

    public ContractType getContractType(EntityContainer<BookingFile> bookingFile) {
        return ContractType.CLIENT;
    }

    public abstract PGConnectorInfo getConnectorInfo();

    public abstract void dispose();

    public abstract PaymentInitiationResult initiatePayment(PaymentInitiationParameters var1);

    public PaymentCheckResult checkPayment(PaymentCheckParameters checkParameters) {
        return this.checkPayment(checkParameters, new HashMap<String, Object>());
    }

    public PaymentCheckResult checkPayment(PaymentCheckParameters parameters, Map<String, Object> ctx) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void paymentInitiated(Payment payment, List<Message> messages) {
        if (this.log.isInfoEnabled()) {
            this.log.info("initiatePayment, " + payment);
        }
        this.getQueueManager().addToQueue(payment);
        payment.setStatus(PaymentStatus.INITIATED);
        PgHandlersRegistry.getPaymentStatusHandler().ifPresent(statusHandler -> statusHandler.paymentInitiated(payment, messages));
    }

    public PgTotalPriceProvider getTotalPriceProvider() {
        return new PgTotalPriceProvider(){

            @Override
            public BigDecimal get(EntityReference<BookingFile> reference, PaymentType paymentType) throws PGException {
                return this.get(reference, null, paymentType);
            }

            @Override
            public BigDecimal get(EntityReference<BookingFile> reference, Collection<Reservation> reservations, PaymentType paymentType) throws PGException {
                try {
                    return PGConnector.this.getTotalPrice(reference, reservations, paymentType);
                }
                catch (Exception e) {
                    PGConnector.this.log.error("getTotalPriceProvider", (Throwable)e);
                    throw new PGException("getTotalPriceProvider", e);
                }
            }
        };
    }

    @Override
    public void paymentSucceeded(Payment payment, List<Message> messages, SalesContext salesContext, EntityContainer<BookingFile> bookingFileCtr) {
        if (Objects.isNull(payment.getPg())) {
            payment.setPg(this.getId());
        }
        PaymentSucceedHandler succeedHandler = this.handlerFactory.createPaymentSucceedHandler().setBookingFile(bookingFileCtr);
        Optional<PaymentStatusHandler> paymentStatusHandler = PgHandlersRegistry.getPaymentStatusHandler();
        succeedHandler.process(paymentStatusHandler.orElse(null), this.getQueueManager(), this.getTotalPriceProvider(), payment, messages, salesContext);
    }

    @Override
    public void paymentSucceeded(Payment payment, List<Message> messages, SalesContext salesContext) {
        this.paymentSucceeded(payment, messages, salesContext, null);
    }

    public void paymentSucceeded(Payment payment, List<Message> messages) throws Exception {
        this.paymentSucceeded(payment, messages, null, null);
    }

    public BigDecimal getTotalPrice(EntityReference<BookingFile> reference, PaymentType paymentType) throws Exception {
        return PaymentHelper.getTotalPrices(reference, this.getContractType()).get(paymentType);
    }

    public BigDecimal getTotalPrice(EntityReference<BookingFile> reference, Collection<Reservation> reservations, PaymentType paymentType) throws Exception {
        return PaymentHelper.getTotalPrices(reference, reservations, this.getContractType()).get(paymentType);
    }

    public void doPaymentReprice(Payment payment) {
        this.handlerFactory.createRepriceHandler().reprice(payment);
    }

    @Override
    public void paymentFailed(Payment payment, List<Message> messages) {
        payment.setStatus(PaymentStatus.FAILED);
        PgHandlersRegistry.getPaymentStatusHandler().ifPresent(statusHandler -> statusHandler.paymentFailed(payment, messages));
        this.getQueueManager().removeFromQueue(payment);
    }

    protected abstract Tracer getTracer();

    protected void configure(PGConnectorRegistry registry) {
        this.enabled = "true".equalsIgnoreCase(((ServerApplication)Environment.getPublished(ServerApplication.class)).getConfiguration().getProperty(String.format("pg.%s.enabled", this.getId().name()), null));
        if (!this.enabled) {
            this.log.info("disabled");
        }
    }

    protected boolean isInQueue(Payment payment) throws Exception {
        return this.getQueueManager().isInQueue(payment);
    }

    protected Long getQueuePeriod() {
        return null;
    }

    protected PaymentInitiationResult defaultInitiateIBusPayment(PaymentInitiationParameters initiationParameters) {
        initiationParameters.setDontDoReprice(true);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(IBusPgContextKeys.INPUT_PAYMENT_PARAMETERS.name(), initiationParameters);
        data.put(IBusPgContextKeys.PG_CONNECTOR.name(), this);
        IntegrationBusFacade.get().processRouteSync("pg-connector:initiate-payment-route", data);
        PaymentInitiationResult initiationResult = (PaymentInitiationResult)data.get(IBusPgContextKeys.OUTPUT_PAYMENT_PARAMETERS.name());
        return initiationResult;
    }

    protected PaymentCheckResult defaultCheckIBusPayment(PaymentCheckParameters checkParameters, Map<String, Object> ctx) {
        HashMap<String, Object> data = new HashMap<String, Object>(ctx);
        data.put(IBusPgContextKeys.INPUT_PAYMENT_PARAMETERS.name(), checkParameters);
        data.put(IBusPgContextKeys.PG_CONNECTOR.name(), this);
        IntegrationBusFacade.get().processRouteSync("pg-connector:check-payment-route", data);
        PaymentCheckResult checkResult = (PaymentCheckResult)data.get(IBusPgContextKeys.OUTPUT_PAYMENT_PARAMETERS.name());
        ctx.putAll(data);
        return checkResult;
    }

    protected PaymentCheckResult defaultCheckIBusPayment(PaymentCheckParameters checkParameters) {
        return this.defaultCheckIBusPayment(checkParameters, new HashMap<String, Object>());
    }

    protected boolean refund(EntityContainer<BookingFile> bfCtr, List<BaseProduct> products, List<Product> feeProducts) {
        throw new UnsupportedOperationException();
    }

    protected void setPaymentCheckResultStatus(PaymentCheckResult result, boolean success) {
        if (success) {
            result.setSuccess(true);
            result.setPaymentStatus(PaymentStatus.SUCCEEDED);
        } else {
            result.setPaymentStatus(PaymentStatus.ERROR);
            result.setSuccess(false);
        }
    }

    protected void logPaymentCheckParameters(PaymentCheckParameters parameters) {
        String USER_REDIRECT_PARAMETER = "request.parameter.";
        List customParameters = parameters.getCustomParameters();
        for (NamedValue namedValue : customParameters) {
            String name = namedValue.getName();
            if (!name.startsWith("request.parameter.") || !this.log.isDebugEnabled()) continue;
            this.log.debug(String.format("Client redirect parameter [%s]", namedValue.getValue()));
        }
    }

    public HandlersFactory getHandlerFactory() {
        return this.handlerFactory;
    }
}

