/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.model.PGConnectorInfo;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.JpfUtil;
import com.gridnine.xtrip.server.pg.FakePGConnector;
import com.gridnine.xtrip.server.pg.PGConnector;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.java.plugin.registry.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PGConnectorRegistry
implements Disposable {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<PgName, PGConnector> pgNameConnectors = new EnumMap<PgName, PGConnector>(PgName.class);
    private final Map<PaymentType, PGConnector> paymentTypeConnectors = new EnumMap<PaymentType, PGConnector>(PaymentType.class);

    public static PGConnectorRegistry get() {
        return Holder.INSTANCE;
    }

    public PGConnectorRegistry() {
        this.registerConnectors();
        this.registerOtherConnectors();
    }

    protected void registerConnectors() {
        String pluginId = "com.gridnine.xtrip.server.pg";
        String pointId = "PGConnectors";
        List connectedExtensions = JpfUtil.getConnectedExtensions((String)pluginId, (String)pointId);
        List parameters = connectedExtensions.stream().flatMap(extension -> extension.getParameters("class").stream()).collect(Collectors.toList());
        for (Extension.Parameter parameter : parameters) {
            try {
                PGConnector connector = (PGConnector)JpfUtil.getClass((Extension.Parameter)parameter).newInstance();
                connector.configure(this);
                this.registerConnector(connector);
            }
            catch (Exception e) {
                this.log.error("failed registering PG connector from " + parameter, (Throwable)e);
            }
        }
    }

    private void registerOtherConnectors() {
        Stream.of(PgName.values()).filter(pgName -> !this.pgNameConnectors.containsKey(pgName)).map(FakePGConnector::new).forEach(this::registerConnector);
    }

    public void dispose() {
        List<PGConnector> pgConnectors = this.pgNameConnectors.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
        this.pgNameConnectors.clear();
        this.paymentTypeConnectors.clear();
        pgConnectors.forEach(PGConnector::dispose);
        if (this.log.isDebugEnabled()) {
            this.log.debug("disposed");
        }
    }

    public void registerConnector(PGConnector connector) throws NullPointerException {
        Objects.requireNonNull(connector);
        PgName pgName = Objects.requireNonNull(connector.getId());
        this.pgNameConnectors.put(pgName, connector);
        PGConnectorInfo connectorInfo = Objects.requireNonNull(connector.getConnectorInfo());
        connectorInfo.getSupportedPaymentTypes().forEach(paymentType -> this.paymentTypeConnectors.put((PaymentType)paymentType, connector));
        if (this.log.isInfoEnabled()) {
            this.log.info("registered PG connector " + connector);
        }
    }

    public Collection<PGConnector> getAll() {
        return this.pgNameConnectors.values();
    }

    public PGConnector get(PgName id) {
        return this.pgNameConnectors.get(id);
    }

    public PGConnector get(PaymentType paymentType) {
        return this.paymentTypeConnectors.get(paymentType);
    }

    private static final class Holder {
        private static final PGConnectorRegistry INSTANCE = new PGConnectorRegistry();

        private Holder() {
        }
    }
}

