/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg;

import com.gridnine.bof.midoffice.helper.MidofficeHelper;
import com.gridnine.bof.midoffice.trace.TraceDataPolicy;
import com.gridnine.bof.midoffice.trace.Tracer;
import com.gridnine.bof.midoffice.trace.TracerConfiguration;
import com.gridnine.bof.midoffice.trace.UnlimitedFilesPolicy;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.booking.WorkflowStatus;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.PGConnectorRegistry;
import com.gridnine.xtrip.server.pg.PGServletResponse;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class PGHelper {
    public static File getConfigurationFile(PgName pg, boolean forSave) {
        String path = String.format("pg/%s.properties", pg.name());
        File result = new File(Environment.getDataFolder(), path);
        if (forSave) {
            if (!result.getParentFile().mkdirs()) {
                throw new RuntimeException("mkdirs() failed for file" + result.getParentFile().getAbsolutePath());
            }
            return result;
        }
        if (!result.isFile()) {
            result = new File(Environment.getConfigurationFolder(), path);
        }
        return result;
    }

    public static Tracer createTracer(PgName pg) {
        Tracer result = new Tracer();
        TracerConfiguration tracerConfig = new TracerConfiguration();
        tracerConfig.setFolder(new File(Environment.getTempFolder(), "pg-trace/" + pg.name()));
        tracerConfig.setPolicy((TraceDataPolicy)new UnlimitedFilesPolicy());
        result.setConfiguration(tracerConfig);
        return result;
    }

    public static Map<String, String> convertRequestParametersMap(Map map) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry entry : map.entrySet()) {
            result.put(String.valueOf(entry.getKey()), String.valueOf(((String[])entry.getValue())[0]));
        }
        return result;
    }

    public static Map<String, String> toLogParameters(Map<String, String[]> parameters) {
        return Objects.requireNonNull(parameters, "no parameters").entrySet().stream().filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, entry -> Arrays.toString((Object[])entry.getValue())));
    }

    public static void redirect(PGServletResponse pgServletResponse, String redirectUrl) {
        if (Objects.isNull(pgServletResponse) || TextUtil.isBlank((String)redirectUrl)) {
            return;
        }
        pgServletResponse.setResponseCode(302);
        pgServletResponse.getHeaders().put("Location", redirectUrl);
    }

    public static Xeption checkWorkflowStatus(BookingFile bookingFile, Collection<Reservation> reservations) {
        boolean payed;
        if (null == bookingFile) {
            return Xeption.forDeveloper((String)"BookingFile is null!", (Object[])new Object[0]);
        }
        boolean bl = payed = MidofficeHelper.getReservations((BookingFile)bookingFile, reservations).stream().anyMatch(r -> r.getStatus() == ReservationStatus.PAYED) || bookingFile.getWorkflowStatus() == WorkflowStatus.PAYED;
        if (payed) {
            return Xeption.forDeveloper((String)"\u041e\u043f\u043b\u0430\u0442\u0430 \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u0430\u0437\u0430 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430, \u0442\u0430\u043a \u043a\u0430\u043a \u0441\u0442\u0430\u0442\u0443\u0441 \u0437\u0430\u043a\u0430\u0437\u0430 \u0432 \u041c\u041e\u041c \"\u041e\u043f\u043b\u0430\u0447\u0435\u043d\"", (Object[])new Object[0]);
        }
        return null;
    }

    public static String getPaymentGateNameFromPaymentType(PaymentType type) {
        PGConnector pgConnector = PGConnectorRegistry.get().get(type);
        if (pgConnector != null) {
            return Optional.ofNullable(pgConnector.getId()).map(Enum::name).orElse(null);
        }
        return null;
    }
}

