/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg;

import com.gridnine.bof.midoffice.trace.TraceItem;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.pg.model.PGLogItem;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.helper.XMLRenderer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PGInvocationContext {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private static final ThreadLocal<PGInvocationContext> contexts = new ThreadLocal<PGInvocationContext>(){

        @Override
        protected PGInvocationContext initialValue() {
            return new PGInvocationContext();
        }
    };
    private final List<TraceData> traceData = new ArrayList<TraceData>();
    private String paymentId;
    private String invocationName;

    public static PGInvocationContext get() {
        return contexts.get();
    }

    public void begin(String name) {
        this.invocationName = name;
        this.traceData.clear();
        this.paymentId = null;
        this.log.debug("BEGIN " + this.invocationName);
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public void setPaymentId(String value) {
        this.paymentId = value;
    }

    public void addTraceData(Date startDate, String transactionName, Object req, Object res, Throwable e) {
        this.addTraceData(startDate, transactionName, XMLRenderer.render(req), XMLRenderer.render(res), e);
    }

    public void addTraceData(int index, Date startDate, String transactionName, Object req, Object res, Throwable e) {
        this.addTraceData(index, startDate, transactionName, XMLRenderer.render(req), XMLRenderer.render(res), e);
    }

    private void addTraceData(int index, Date startDate, String transactionName, Element req, Element res, Throwable e) {
        this.traceData.add(index, new TraceData(startDate, transactionName, req, res, e));
    }

    private void addTraceData(Date startDate, String transactionName, Element req, Element res, Throwable e) {
        this.traceData.add(new TraceData(startDate, transactionName, req, res, e));
    }

    public void end(PGConnector connector, List<PGLogItem> pgLog) {
        PGLogItem logItem = null;
        if (connector.getTracer() != null && (logItem = this.buildLogItem(connector.getId())) != null) {
            connector.getTracer().trace(new TraceItem[]{new PGTraceItem(this.invocationName, logItem)});
        }
        if (pgLog != null) {
            if (logItem == null) {
                logItem = this.buildLogItem(connector.getId());
            }
            if (logItem != null) {
                pgLog.add(logItem);
            }
        }
        this.traceData.clear();
        this.log.debug("END " + this.invocationName);
    }

    private PGLogItem buildLogItem(PgName pg) {
        if (this.traceData.isEmpty()) {
            return null;
        }
        PGLogItem result = new PGLogItem();
        result.setName(this.invocationName);
        result.setPg(pg);
        result.setDate(new Date());
        result.setPaymentId(this.paymentId);
        result.setTitle("\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 " + result.getPg() + " " + this.invocationName);
        result.setContentType(ContentType.XML);
        Document doc = DocumentBuilderHelper.newDocument();
        Element root = doc.createElement("payment-gate-transactions");
        doc.appendChild(root);
        root.setAttribute("invocation-name", this.invocationName);
        for (TraceData data : this.traceData) {
            try {
                root.appendChild(this.buildElement(doc, data));
            }
            catch (Throwable t) {
                this.log.error("failed building log element", t);
            }
        }
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            XUtil.newTransformer().transform(new DOMSource(doc), new StreamResult(output));
            result.setTraceData(output.toByteArray());
        }
        catch (Throwable t) {
            this.log.error("failed rendering trace data", t);
        }
        return result;
    }

    private Element buildElement(Document doc, TraceData data) {
        Element result = doc.createElement("transaction");
        result.setAttribute("name", data.transaction);
        if (data.date1 != null) {
            result.setAttribute("date", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(data.date1));
            result.setAttribute("timing", String.valueOf(data.date2.getTime() - data.date1.getTime()));
        }
        if (this.paymentId != null) {
            result.setAttribute("paymentId", this.paymentId);
        }
        if (data.request != null) {
            XmlUtil.addElement((Element)result, (String)"request").appendChild(doc.importNode(data.request, true));
        }
        if (data.response != null) {
            XmlUtil.addElement((Element)result, (String)"response").appendChild(doc.importNode(data.response, true));
        }
        if (data.error != null) {
            Element errElm = (Element)result.appendChild(doc.createElement("error"));
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            data.error.printStackTrace(printWriter);
            printWriter.flush();
            XmlUtil.setValue((Element)errElm, (String)stringWriter.toString());
        }
        return result;
    }

    public void saveDocs(List<PGLogItem> pgLog, List<Message> messages, EntityReference<? extends BaseEntity> payeeRef) {
    }

    private static class PGTraceItem
    implements TraceItem {
        private final String invocationName;
        private final PGLogItem logItem;
        private final String id;

        PGTraceItem(String name, PGLogItem item) {
            this.invocationName = name;
            this.logItem = item;
            this.id = String.format("%s-%s.xml", this.invocationName, MiscUtil.getTimestamp());
        }

        public String getId() {
            return this.id;
        }

        public void write(OutputStream strm) throws IOException {
            strm.write(this.logItem.getTraceData());
        }
    }

    private static class TraceData {
        final Date date1;
        final Date date2;
        final String transaction;
        final Element request;
        final Element response;
        final Throwable error;

        TraceData(Date startDate, String tr, Element req, Element res, Throwable e) {
            this.date1 = startDate;
            this.date2 = new Date();
            this.transaction = tr;
            this.request = req;
            this.response = res;
            this.error = e;
        }
    }
}

