/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg;

import com.gridnine.xtrip.common.pg.model.PGLogItem;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.LogicalMessageContext;
import javax.xml.ws.handler.MessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class PGLoggingHandler
implements LogicalHandler<LogicalMessageContext> {
    static final String KEY_INBOUND_PAYLOAD = PGLoggingHandler.class.getName() + ":inbound-payload";
    static final String KEY_OUTBOUND_PAYLOAD = PGLoggingHandler.class.getName() + ":outbound-payload";
    static final String KEY_START_DATE = PGLoggingHandler.class.getName() + ":start-date";
    static final String KEY_DIRECTION = PGLoggingHandler.class.getName() + ":direction";
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());

    public boolean handleMessage(LogicalMessageContext context) {
        boolean hasData;
        boolean outbound = "true".equalsIgnoreCase(String.valueOf(context.get((Object)"javax.xml.ws.handler.message.outbound")));
        boolean bl = hasData = context.containsKey((Object)KEY_OUTBOUND_PAYLOAD) || context.containsKey((Object)KEY_INBOUND_PAYLOAD);
        if (hasData) {
            context.put((Object)KEY_DIRECTION, (Object)(outbound ? "io" : "oi"));
        }
        if (outbound) {
            context.put((Object)KEY_START_DATE, (Object)new Date());
        }
        try {
            context.put((Object)(outbound ? KEY_OUTBOUND_PAYLOAD : KEY_INBOUND_PAYLOAD), (Object)this.buildPayload(context.getMessage().getPayload()));
        }
        catch (Exception e) {
            this.log.error("failed building payload element", (Throwable)e);
        }
        return true;
    }

    public boolean handleFault(LogicalMessageContext context) {
        this.handleMessage(context);
        this.log.error("invocation failed, message context: " + context);
        return true;
    }

    private Element buildPayload(Source source) throws Exception {
        Document doc = DocumentBuilderHelper.newDocument();
        XUtil.newTransformer().transform(source, new DOMResult(doc));
        return doc.getDocumentElement();
    }

    public void close(MessageContext context) {
        try {
            Element reqPayload = (Element)context.get((Object)KEY_OUTBOUND_PAYLOAD);
            Element resPayload = (Element)context.get((Object)KEY_INBOUND_PAYLOAD);
            Date startDate = (Date)context.get((Object)KEY_START_DATE);
            Document doc = DocumentBuilderHelper.newDocument();
            Element req = doc.createElement("request");
            PGLoggingHandler.buildPart(req, (Map)context.get((Object)"javax.xml.ws.http.request.headers"), reqPayload);
            Element res = doc.createElement("response");
            PGLoggingHandler.buildPart(res, (Map)context.get((Object)"javax.xml.ws.http.response.headers"), resPayload);
            String transactionName = reqPayload.getLocalName();
            PGInvocationContext.get().addTraceData(startDate, transactionName, (Object)req, (Object)res, null);
            if ("io".equals(context.get((Object)KEY_DIRECTION))) {
                PGInvocationContext.get().end(this.getConnector(), new ArrayList<PGLogItem>());
            }
        }
        catch (Exception e) {
            this.log.error("failed building trace data", (Throwable)e);
        }
    }

    protected abstract PGConnector getConnector();

    private static void buildPart(Element elm, Map<String, List<String>> headers, Element payload) throws Exception {
        if (headers != null) {
            Element ctrElm = elm.getOwnerDocument().createElement("headers");
            elm.appendChild(ctrElm);
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                for (String value : entry.getValue()) {
                    Element headerElm = ctrElm.getOwnerDocument().createElement("header");
                    ctrElm.appendChild(headerElm);
                    headerElm.setAttribute("name", entry.getKey());
                    headerElm.setAttribute("value", value);
                }
            }
        }
        if (payload != null) {
            elm.appendChild(elm.getOwnerDocument().createElement("payload")).appendChild(elm.getOwnerDocument().importNode(payload, true));
        }
    }
}

