/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg;

import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.pg.rules.Targets;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.rules.proxy.PGParametersActions;
import com.gridnine.xtrip.server.pg.rules.proxy.PGParametersProperties;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PGRulesHelper {
    private static final Logger log = LoggerFactory.getLogger(PGRulesHelper.class);
    private static final Logger proxyTraceLog = LoggerFactory.getLogger((String)(PGConnector.class.getName() + ".RULES_TRACE"));

    public static PGParameters newPgParameters(SalesContext salesContext, PGParametersProperties pgParametersProperties) throws Exception {
        Objects.requireNonNull(salesContext);
        Objects.requireNonNull(pgParametersProperties);
        RuleSet rules = SalesContextHandler.get().getRules(salesContext);
        RuleProxy ruleProxy = new RuleProxy();
        ruleProxy.setProxyType(Targets.PG_PARAMETERS.getId());
        ruleProxy.setProxyDate(new Date());
        ruleProxy.getTracer().setDisabled(!proxyTraceLog.isDebugEnabled());
        ruleProxy.setPropertySet((Object)pgParametersProperties);
        ruleProxy.setActionSet((Object)new PGParametersActions());
        RuleEngine.applyRules(Collections.singletonList(ruleProxy), (RuleSet)rules);
        return PGRulesHelper.of((PGParametersActions)ruleProxy.getActionSet());
    }

    public static PGParameters getPGParameters(SalesContext salesContext, PgName pgName, Payment payment) throws Exception {
        PGParametersProperties pgParametersProperties = PGParametersProperties.newInstance(pgName, payment);
        return PGRulesHelper.newPgParameters(salesContext, pgParametersProperties);
    }

    private static PGParameters of(PGParametersActions actions) {
        PGParameters pgParameters = new PGParameters();
        if (TextUtil.nonBlank((String)actions.getPgAccount())) {
            pgParameters.setPgAccount(actions.getPgAccount());
        }
        if (TextUtil.nonBlank((String)actions.getPgPassword())) {
            pgParameters.setPgPassword(actions.getPgPassword());
        }
        if (Objects.nonNull(actions.getPgServiceUrl())) {
            pgParameters.setPgServiceUrl(actions.getPgServiceUrl());
        }
        if (Objects.nonNull(actions.getPgRedirectUrl())) {
            pgParameters.setPgRedirectUrl(actions.getPgRedirectUrl());
        }
        pgParameters.getApplicablePG().addAll(actions.getApplicablePG());
        return pgParameters;
    }
}

