/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg;

import com.gridnine.xtrip.common.util.TextUtil;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PGServletResponse {
    private static final Logger log = LoggerFactory.getLogger(PGServletResponse.class);
    private final HttpServletResponse servletResponse;
    private int responseCode = 200;
    private String responseText;
    private String contentType = "text/xml;charset=utf-8";
    private String characterEncoding = "utf-8";
    private final Map<String, String> headers = new LinkedHashMap<String, String>();

    public PGServletResponse(HttpServletResponse response) {
        this.servletResponse = response;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int value) {
        this.responseCode = value;
    }

    public String getResponseText() {
        return this.responseText;
    }

    public void setResponseText(String value) {
        this.responseText = value;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void send() {
        this.servletResponse.setStatus(this.responseCode);
        this.servletResponse.setCharacterEncoding(this.characterEncoding);
        this.servletResponse.setContentType(this.contentType);
        if (!TextUtil.isBlank((String)this.responseText)) {
            try {
                this.servletResponse.getWriter().write(this.responseText);
            }
            catch (IOException ex) {
                log.warn("write error", (Throwable)ex);
            }
        }
        this.headers.entrySet().stream().filter(Objects::nonNull).filter(header -> TextUtil.nonBlank((String)((String)header.getKey())) && TextUtil.nonBlank((String)((String)header.getValue()))).forEach(header -> this.servletResponse.addHeader((String)header.getKey(), (String)header.getValue()));
    }
}

