/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg;

import com.gridnine.xtrip.common.async.AsyncCommand;
import com.gridnine.xtrip.common.async.AsyncCommandOption;
import com.gridnine.xtrip.common.async.AsyncExecutor;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentCheckParameters;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.server.pg.PGConnectorRegistry;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentChecker {
    static final Logger log = LoggerFactory.getLogger(PaymentChecker.class);

    public static void schedule(Payment payment, SalesContext salesContext, PgName pgName) throws Exception {
        PaymentCheckParameters checkParameters = new PaymentCheckParameters();
        checkParameters.setPayment(payment);
        checkParameters.setSalesContext(salesContext);
        checkParameters.setPg(pgName);
        CheckPaymentAsyncCommand checkPaymentAsyncCommand = new CheckPaymentAsyncCommand(checkParameters);
        AsyncExecutor.get().execute(PaymentChecker.class.getName(), (AsyncCommand)checkPaymentAsyncCommand, new AsyncCommandOption[0]);
    }

    private static class CheckPaymentAsyncCommand
    implements AsyncCommand<Exception> {
        private static final long serialVersionUID = -7310127592297639842L;
        private final PaymentCheckParameters checkParameters;

        private CheckPaymentAsyncCommand(PaymentCheckParameters checkParameters) {
            this.checkParameters = checkParameters;
        }

        public void run() throws Exception {
            if (log.isDebugEnabled()) {
                log.debug("Checking payment {} of {}", (Object)this.checkParameters.getPayment().getPaymentId(), (Object)this.checkParameters.getPg().toString());
            }
            PGConnectorRegistry.get().get(this.checkParameters.getPg()).checkPayment(this.checkParameters, new HashMap<String, Object>());
        }
    }
}

