/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg;

import com.gridnine.bof.midoffice.helper.MidofficeHelper;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.WorkflowStatus;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentHelper;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.delivery.DeliveryItem;
import com.gridnine.xtrip.common.model.delivery.DeliveryStatus;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineCard;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AeroexpressTicketHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.model.pg.SplitPaymentRegistry;
import com.gridnine.xtrip.common.model.pg.SplitPaymentSupport;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.SalesPointAirlineInfo;
import com.gridnine.xtrip.common.model.system.BillingTransaction;
import com.gridnine.xtrip.common.model.system.CardTransactionDetails;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.pg.AcceptedCardsProvider;
import com.gridnine.xtrip.common.pg.model.PGConnectorInfo;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.pg.model.PgPaymentIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.rules.BookingCommissionsCalculator;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.PGConnectorRegistry;
import com.gridnine.xtrip.server.pg.PgPaymentBuilder;
import com.gridnine.xtrip.server.pg.handlers.CustomProductFopsHandler;
import com.gridnine.xtrip.server.pg.handlers.PgHandlersRegistry;
import com.gridnine.xtrip.server.pg.helper.AllowedPaymentTypesHandler;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentHelper {
    private static final transient Logger log = LoggerFactory.getLogger(PaymentHelper.class);

    public static Payment createPayment(EntityContainer<BookingFile> bookingFileCtr, ContractType contractType) throws Exception {
        BookingFile bookingFile = (BookingFile)bookingFileCtr.getEntity();
        BigDecimal totalPrice = PaymentHelper.getPaymentPrice(bookingFile, contractType, null, null);
        BigDecimal totalFee = PaymentHelper.getTotalFee(bookingFile, contractType);
        return ((PgPaymentBuilder)((PgPaymentBuilder)((PgPaymentBuilder)new PgPaymentBuilder().setBookingFileCtr(bookingFileCtr)).setAmount(totalPrice)).setFee(totalFee)).build();
    }

    public static Payment createPayment(EntityContainer<BookingFile> bookingFileCtr, Collection<Reservation> reservations, ContractType contractType) throws Exception {
        BigDecimal totalPrice = PaymentHelper.getPaymentPrice(reservations, contractType, null, null);
        BigDecimal totalFee = PaymentHelper.getTotalFee(reservations, contractType);
        return ((PgPaymentBuilder)((PgPaymentBuilder)((PgPaymentBuilder)((PgPaymentBuilder)new PgPaymentBuilder().setBookingFileCtr(bookingFileCtr)).setReservations(reservations)).setAmount(totalPrice)).setFee(totalFee)).build();
    }

    public static SalesContext restoreSalesContext(Payment payment) throws Exception {
        if (payment.getEntity() != null && BookingFile.class.equals((Object)payment.getEntity().getType())) {
            EntityContainer bfCtr = EntityStorage.get().resolve(payment.getEntity());
            return PaymentHelper.restoreSalesContext((EntityContainer<BookingFile>)bfCtr);
        }
        if (payment.getPayee() != null && payment.getPayer() != null) {
            return null;
        }
        throw new Exception("unexpected case");
    }

    public static SalesContext restoreSalesContext(EntityContainer<BookingFile> bfCtr) {
        return SalesContextHandler.get().createSalesContext((Reservation)((BookingFile)bfCtr.getEntity()).getReservations().get(0));
    }

    public static SalesContext restoreSalesContext(Reservation reservation) {
        return SalesContextHandler.get().createSalesContext(reservation);
    }

    public static Payment createPayment(EntityContainer<BookingFile> bookingFileCtr, PaymentType paymentType, ContractType contractType) throws Exception {
        Map<PaymentType, BigDecimal> totalPrices = PaymentHelper.getTotalPrices((EntityReference<BookingFile>)bookingFileCtr.toReference(), contractType);
        BigDecimal amount = totalPrices.get(paymentType);
        if (amount == null) {
            throw new Exception(String.format("null price for payment type %s in booking file \u2116 %S", paymentType, ((BookingFile)bookingFileCtr.getEntity()).getNumber()));
        }
        BigDecimal totalFee = PaymentHelper.getTotalFee((BookingFile)bookingFileCtr.getEntity(), contractType);
        return ((PgPaymentBuilder)((PgPaymentBuilder)((PgPaymentBuilder)((PgPaymentBuilder)new PgPaymentBuilder().setBookingFileCtr(bookingFileCtr)).setPaymentType(paymentType)).setAmount(amount)).setFee(totalFee)).build();
    }

    public static Payment createPayment(EntityContainer<BookingFile> bookingFileCtr, PaymentType paymentType, BigDecimal amount) throws Exception {
        if (amount == null) {
            throw new Exception(String.format("null price for payment type %s", paymentType));
        }
        return ((PgPaymentBuilder)((PgPaymentBuilder)((PgPaymentBuilder)new PgPaymentBuilder().setBookingFileCtr(bookingFileCtr)).setPaymentType(paymentType)).setAmount(amount)).build();
    }

    public static Payment createPayment(EntityContainer<Organization> organizationCtr, EntityContainer<Organization> agencyCtr, BigDecimal amount) {
        Payment payment = new Payment();
        payment.setPaymentId(UUID.randomUUID().toString());
        payment.setAmount(amount);
        payment.setPayee(agencyCtr.toReference());
        payment.setPayer(organizationCtr.toReference());
        payment.setDescription(String.format("\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 %s \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u041f\u043e\u0440\u0442\u0431\u0438\u043b\u0435\u0442", ((Organization)organizationCtr.getEntity()).getShortName()));
        return payment;
    }

    public static Fop createFop(Payment payment) {
        Fop result = new Fop();
        result.setType(payment.getPaymentType());
        if (payment.getDetails() != null) {
            Card card = new Card();
            card.setExpiration(payment.getDetails().getExpiration());
            card.setNameOnCard(payment.getDetails().getNameOnCard());
            card.setNumber(payment.getDetails().getNumber());
            card.setRemarks(payment.getDetails().getRemarks());
            card.setSecurityCode(payment.getDetails().getSecurityCode());
            card.setVendor(payment.getDetails().getVendor());
            result.setCard(card);
        }
        return result;
    }

    public static BigDecimal calculateProductPrice(BaseProduct bp, ContractType contractType) {
        BigDecimal fee;
        ProductHandler handler = HandlersRegistry.get().findProductHandler(bp.getClass());
        if (handler == null) {
            LoggerFactory.getLogger(PaymentHelper.class).error("no product handler is registered for product class " + bp.getClass().getName());
            return BigDecimal.ZERO;
        }
        BigDecimal result = BigDecimal.ZERO;
        VatAmount productPrice = handler.calculateProductPrice(bp, contractType);
        if (productPrice != null && productPrice.getTotal() != null) {
            result = result.add(productPrice.getTotal());
        }
        if (contractType != null && (fee = GeneralProductHelper.calculateFee((BaseProduct)bp, (ContractType)contractType)) != null) {
            result = result.add(fee);
        }
        return result;
    }

    @Deprecated
    public static CardVendor determineCardVendor(String number) {
        if (TextUtil.isBlank((String)number)) {
            return null;
        }
        if (number.startsWith("4")) {
            return CardVendor.VISA;
        }
        if (number.startsWith("51") || number.startsWith("52") || number.startsWith("53") || number.startsWith("54") || number.startsWith("55")) {
            return CardVendor.MASTERCARD;
        }
        if (number.startsWith("34") || number.startsWith("37")) {
            return CardVendor.AMEX;
        }
        log.warn(String.format("could not determine card vendor for number %s - returned null", number));
        return null;
    }

    public static Map<PaymentType, BigDecimal> getTotalPrices(EntityReference<BookingFile> bfRef, ContractType contractType) throws Exception {
        log.debug("getTotalPrices() BEGIN");
        EntityContainer bfCtr = EntityStorage.get().resolve(bfRef);
        if (bfCtr == null) {
            throw new Exception("\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0437\u0430\u043a\u0430\u0437 " + bfRef);
        }
        Map<PaymentType, BigDecimal> result = PaymentHelper.getTotalPrices((EntityContainer<BookingFile>)bfCtr, contractType);
        log.debug("getTotalPrices() END");
        return result;
    }

    public static Map<PaymentType, BigDecimal> getTotalPrices(EntityReference<BookingFile> bfRef, Collection<Reservation> reservations, ContractType contractType) throws Exception {
        log.debug("getTotalPrices() BEGIN");
        EntityContainer bfCtr = EntityStorage.get().resolve(bfRef);
        if (bfCtr == null) {
            throw new Exception("\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0437\u0430\u043a\u0430\u0437 " + bfRef);
        }
        Map<PaymentType, BigDecimal> result = reservations != null ? PaymentHelper.getTotalPrices((EntityContainer<BookingFile>)bfCtr, (Collection<Reservation>)MidofficeHelper.getReservations((EntityContainer)bfCtr, reservations), contractType) : PaymentHelper.getTotalPrices((EntityContainer<BookingFile>)bfCtr, contractType);
        log.debug("getTotalPrices() END");
        return result;
    }

    public static Collection<Reservation> getReservations(EntityContainer<BookingFile> bookingFileCtr, Collection<String> reservations) {
        return PaymentHelper.getReservations((BookingFile)bookingFileCtr.getEntity(), reservations);
    }

    public static Collection<Reservation> getReservations(BookingFile bookingFile, Collection<String> reservations) {
        return reservations != null && !reservations.isEmpty() ? (Collection)bookingFile.getReservations().stream().filter(r -> reservations.contains(r.getUid())).collect(Collectors.toList()) : null;
    }

    public static Map<PaymentType, BigDecimal> getTotalPrices(EntityContainer<BookingFile> bfCtr, ContractType contractType) throws Exception {
        return PaymentHelper.getTotalPrices(bfCtr, contractType, AllowedPaymentTypesHandler.get().getAllowedPaymentTypes(bfCtr));
    }

    public static Map<PaymentType, BigDecimal> getTotalPrices(EntityContainer<BookingFile> bfCtr, Collection<Reservation> reservations, ContractType contractType) throws Exception {
        return PaymentHelper.getTotalPrices(bfCtr, reservations, contractType, AllowedPaymentTypesHandler.get().getAllowedPaymentTypes(bfCtr, reservations));
    }

    public static Map<PaymentType, BigDecimal> getTotalPrices(EntityContainer<BookingFile> bfCtr, ContractType contractType, Set<PaymentType> allowedPaymentTypes) throws Exception {
        return PaymentHelper.getTotalPrices(bfCtr, contractType, allowedPaymentTypes, null);
    }

    public static Map<PaymentType, BigDecimal> getTotalPrices(EntityContainer<BookingFile> bfCtr, Collection<Reservation> reservations, ContractType contractType, Set<PaymentType> allowedPaymentTypes) throws Exception {
        return PaymentHelper.getTotalPrices(bfCtr, reservations, contractType, allowedPaymentTypes, null);
    }

    public static void applyRules(EntityContainer<BookingFile> bfCtr, PaymentType paymentType) throws Exception {
        boolean isRetailProfile;
        if (bfCtr == null || paymentType == null) {
            log.debug(String.format("empty data for apply rules [%s, %s]", ((BookingFile)bfCtr.getEntity()).getNumber(), paymentType));
            throw new Exception(String.format("empty on of [%s, %s]", bfCtr, paymentType));
        }
        log.debug(String.format("try apply rules for order=[%s] by patmentType=[%s]", ((BookingFile)bfCtr.getEntity()).getNumber(), paymentType.name()));
        SplitPaymentRegistry splitPaymentRegistry = (SplitPaymentRegistry)Environment.getPublished(SplitPaymentRegistry.class);
        boolean isSplitPayment = splitPaymentRegistry.isSplitPayment(paymentType);
        PGConnector pgConnector = null;
        if (isSplitPayment) {
            boolean canUseSplitScheme;
            pgConnector = PaymentHelper.getPgConnector(paymentType, true);
            try {
                canUseSplitScheme = ((SplitPaymentSupport)pgConnector).canUseSplitScheme(bfCtr);
            }
            catch (Exception e) {
                canUseSplitScheme = false;
            }
            if (!canUseSplitScheme) {
                log.debug(String.format("try apply rules faild for order=[%s] by patmentType=[%s] because can't use split scheme", ((BookingFile)bfCtr.getEntity()).getNumber(), paymentType));
                throw new Exception(String.format("[%s] can't use split scheme", paymentType));
            }
        }
        ContractType contractType = (isRetailProfile = ProfileHelper.isRetailProfile((EntityReference)((BookingFile)bfCtr.getEntity()).getCustomerProfile())) ? ContractType.SUBAGENCY : ContractType.CLIENT;
        EntityReference agency = null;
        EntityReference agent = null;
        EntityReference salesPoint = null;
        Date issueDate = null;
        boolean isUpdateSplitFops = false;
        if (isSplitPayment) {
            isUpdateSplitFops = ((SplitPaymentSupport)pgConnector).canUseSplitScheme(bfCtr);
        }
        for (Reservation res : ((BookingFile)bfCtr.getEntity()).getReservations()) {
            for (BaseProduct bp : res.getProducts()) {
                ProductHandler handler = HandlersRegistry.get().findProductHandler(bp.getClass());
                if (isUpdateSplitFops) {
                    PaymentHelper.recreateSplitFops(bp, (ProductHandler<BaseProduct>)handler, (SplitPaymentSupport)pgConnector);
                } else {
                    GeneralProductHelper.updateAllFOPs((BaseProduct)bp, (PaymentType)paymentType);
                    List vendorFops = GeneralProductHelper.getUnmodifiableFops((BaseProduct)bp, (ContractType)ContractType.VENDOR);
                    for (GeneralProductFop item : vendorFops) {
                        item.setType(PaymentType.INVOICE);
                    }
                    GeneralProductHelper.updateFops((BaseProduct)bp, (ContractType)ContractType.VENDOR, (List)vendorFops);
                }
                if (agency == null) {
                    agency = GeneralProductHelper.getAgency((BaseProduct)bp);
                }
                if (agent == null) {
                    agent = handler.findIssuingAgent(bp);
                }
                if (salesPoint == null) {
                    salesPoint = handler.findSalesPoint(bp);
                }
                if (issueDate != null) continue;
                issueDate = handler.findIssueDate(bp);
            }
        }
        if (agency == null) {
            agency = ((BookingFile)bfCtr.getEntity()).getAgency();
        }
        if (paymentType.name().contains("DELIVERY")) {
            Reservation res = new Reservation();
            ((BookingFile)bfCtr.getEntity()).getReservations().add(res);
            res.setBookingFile((BookingFile)bfCtr.getEntity());
            res.getGdsNameInfo().setRulesGdsName(GdsName.WEB_SITE);
            Delivery delivery = new Delivery();
            delivery.setReservation(res);
            res.getProducts().add(delivery);
            delivery.setAgency(agency);
            delivery.setAgent(agent);
            delivery.setIssueDate(issueDate);
            delivery.setReservation(res);
            delivery.setSalesPoint(salesPoint);
            delivery.setStatus(DeliveryStatus.PLANNED);
            for (Reservation res2 : ((BookingFile)bfCtr.getEntity()).getReservations()) {
                for (BaseProduct bp : res2.getProducts()) {
                    VatAmount productPrice;
                    DeliveryItem item = new DeliveryItem();
                    item.setProductUid(bp.getUid());
                    item.setBooking(bfCtr.toReference());
                    ProductHandler handler = HandlersRegistry.get().findProductHandler(bp.getClass());
                    Fop fop = GeneralProductHelper.findFop((BaseProduct)bp);
                    item.setPaymentType(fop == null ? PaymentType.CASH : fop.getType());
                    item.setName(handler.generateShortProductName(bp));
                    BigDecimal cost = GeneralProductHelper.calculateFee((BaseProduct)bp, (ContractType)contractType);
                    if (cost == null) {
                        cost = BigDecimal.ZERO;
                    }
                    if ((productPrice = handler.calculateProductPrice(bp, ContractType.CLIENT)) != null) {
                        cost = cost.add(productPrice.getTotal());
                    }
                    item.setCost(cost);
                    delivery.getDeliveryItems().add(item);
                }
            }
        }
        ArrayList messages = new ArrayList();
        HashMap params = new HashMap();
        ((BookingCommissionsCalculator)Environment.getPublished(BookingCommissionsCalculator.class)).applyRules(bfCtr, true, true, messages, params, null);
        log.debug(String.format("apply rules for order=[%s] by paymentType=[%s], forRetail=[%s], contractType=[%s], isSplitPayment=[%s], isUpdateSplitFops=[%s]", ((BookingFile)bfCtr.getEntity()).getNumber(), paymentType.name(), isRetailProfile, contractType.name(), isSplitPayment, isUpdateSplitFops));
    }

    public static Map<PaymentType, BigDecimal> getTotalPrices(EntityContainer<BookingFile> bfCtr, ContractType contractType, Set<PaymentType> allowedPaymentTypes, BookingHelper.ProductTotalPrice productTotalPrice) throws Exception {
        return PaymentHelper.getTotalPrices(bfCtr, null, contractType, allowedPaymentTypes, productTotalPrice);
    }

    public static Map<PaymentType, BigDecimal> getTotalPrices(EntityContainer<BookingFile> bfCtr, Collection<Reservation> reservations, ContractType contractType, Set<PaymentType> allowedPaymentTypes, BookingHelper.ProductTotalPrice productTotalPrice) throws Exception {
        return PaymentHelper.getTotalPrices(bfCtr, reservations, contractType, allowedPaymentTypes, productTotalPrice, null);
    }

    public static Map<PaymentType, BigDecimal> getTotalPrices(EntityContainer<BookingFile> bfCtr, Collection<Reservation> reservations, ContractType contractType, Set<PaymentType> allowedPaymentTypes, BookingHelper.ProductTotalPrice productTotalPrice, Card card) throws Exception {
        HashMap<PaymentType, BigDecimal> result = new HashMap<PaymentType, BigDecimal>();
        SplitPaymentRegistry splitPaymentRegistry = (SplitPaymentRegistry)Environment.getPublished(SplitPaymentRegistry.class);
        Iterator<PaymentType> iterator = allowedPaymentTypes.iterator();
        while (iterator.hasNext()) {
            PaymentType paymentType = iterator.next();
            boolean isSplitPayment = splitPaymentRegistry.isSplitPayment(paymentType);
            if (!isSplitPayment) continue;
            PGConnector pgConnector = PaymentHelper.getPgConnector(paymentType, true);
            boolean canUseSplitScheme = reservations != null ? ((SplitPaymentSupport)pgConnector).canUseSplitScheme(reservations) : ((SplitPaymentSupport)pgConnector).canUseSplitScheme(bfCtr);
            if (canUseSplitScheme) continue;
            iterator.remove();
        }
        for (PaymentType paymentType : allowedPaymentTypes) {
            EntityContainer cloneCtr = new EntityContainer(BookingFile.class);
            XCloneModelHelper.copy(bfCtr, (BaseEntity)cloneCtr, (boolean)false);
            EntityReference agency = null;
            EntityReference agent = null;
            EntityReference salesPoint = null;
            Date issueDate = null;
            PGConnector pgConnector = null;
            boolean isSplitPayment = splitPaymentRegistry.isSplitPayment(paymentType);
            boolean isUpdateSplitFops = false;
            if (isSplitPayment) {
                pgConnector = PaymentHelper.getPgConnector(paymentType, true);
                isUpdateSplitFops = true;
            }
            for (Reservation res2 : ((BookingFile)cloneCtr.getEntity()).getReservations()) {
                for (BaseProduct bp : res2.getProducts()) {
                    ProductHandler handler = HandlersRegistry.get().findProductHandler(bp.getClass());
                    if (isUpdateSplitFops) {
                        PaymentHelper.recreateSplitFops(bp, (ProductHandler<BaseProduct>)handler, (SplitPaymentSupport)pgConnector);
                    } else {
                        GeneralProductHelper.updateAllFOPs((BaseProduct)bp, (PaymentType)paymentType);
                        List vendorFops = GeneralProductHelper.getUnmodifiableFops((BaseProduct)bp, (ContractType)ContractType.VENDOR);
                        for (Object item : vendorFops) {
                            item.setType(PaymentType.INVOICE);
                        }
                        GeneralProductHelper.updateFops((BaseProduct)bp, (ContractType)ContractType.VENDOR, (List)vendorFops);
                        if (card != null) {
                            Object item;
                            List relations = handler.getUnmodifiableContractRelations(bp);
                            item = relations.iterator();
                            while (item.hasNext()) {
                                GeneralProductContractRelationData relation = (GeneralProductContractRelationData)item.next();
                                relation.getFops().forEach(fop -> fop.setCard(card));
                            }
                            handler.updateContractRelations(bp, relations);
                        }
                    }
                    if (agency == null) {
                        agency = GeneralProductHelper.getAgency((BaseProduct)bp);
                    }
                    if (agent == null) {
                        agent = handler.findIssuingAgent(bp);
                    }
                    if (salesPoint == null) {
                        salesPoint = handler.findSalesPoint(bp);
                    }
                    if (issueDate != null) continue;
                    issueDate = handler.findIssueDate(bp);
                }
            }
            if (agency == null) {
                agency = ((BookingFile)bfCtr.getEntity()).getAgency();
            }
            if (paymentType.name().contains("DELIVERY")) {
                Reservation res3 = new Reservation();
                ((BookingFile)cloneCtr.getEntity()).getReservations().add(res3);
                res3.setBookingFile((BookingFile)cloneCtr.getEntity());
                res3.getGdsNameInfo().setRulesGdsName(GdsName.WEB_SITE);
                Delivery delivery = new Delivery();
                delivery.setReservation(res3);
                res3.getProducts().add(delivery);
                delivery.setAgency(agency);
                delivery.setAgent(agent);
                delivery.setIssueDate(issueDate);
                delivery.setReservation(res3);
                delivery.setSalesPoint(salesPoint);
                delivery.setStatus(DeliveryStatus.PLANNED);
                for (Reservation res2 : ((BookingFile)cloneCtr.getEntity()).getReservations()) {
                    for (BaseProduct bp : res2.getProducts()) {
                        VatAmount productPrice;
                        DeliveryItem item = new DeliveryItem();
                        item.setProductUid(bp.getUid());
                        item.setBooking(cloneCtr.toReference());
                        ProductHandler handler = HandlersRegistry.get().findProductHandler(bp.getClass());
                        Fop fop2 = GeneralProductHelper.findFop((BaseProduct)bp);
                        item.setPaymentType(fop2 == null ? PaymentType.CASH : fop2.getType());
                        item.setName(handler.generateShortProductName(bp));
                        BigDecimal cost = GeneralProductHelper.calculateFee((BaseProduct)bp, (ContractType)contractType);
                        if (cost == null) {
                            cost = BigDecimal.ZERO;
                        }
                        if ((productPrice = handler.calculateProductPrice(bp, ContractType.CLIENT)) != null) {
                            cost = cost.add(productPrice.getTotal());
                        }
                        item.setCost(cost);
                        delivery.getDeliveryItems().add(item);
                    }
                }
            }
            ArrayList messages = new ArrayList();
            HashMap params = new HashMap();
            ((BookingCommissionsCalculator)Environment.getPublished(BookingCommissionsCalculator.class)).applyRules(cloneCtr, true, true, messages, params, null);
            List<Reservation> clonedReservations = ((BookingFile)cloneCtr.getEntity()).getReservations().stream().filter(res -> reservations == null || reservations.contains(res)).collect(Collectors.toList());
            BigDecimal totalPrice = PaymentHelper.getPaymentPrice(clonedReservations, contractType, paymentType, productTotalPrice);
            result.put(paymentType, totalPrice);
            if (!log.isDebugEnabled()) continue;
            log.debug(String.format("Total price for [%s], paymentType=[%s], isSplitPayment[%b], isUpdateSplitFops[%s], totalPrice[%.2f]", ((BookingFile)bfCtr.getEntity()).getNumber(), paymentType.name(), isSplitPayment, isUpdateSplitFops, totalPrice));
        }
        log.debug(String.format("Total prices for booking file %s, contract type %s are %s", ((BookingFile)bfCtr.getEntity()).getNumber(), contractType.name(), result));
        return result;
    }

    public static BigDecimal getPaymentPrice(BaseProduct product, ContractType contractType, PaymentType paymentType, BookingHelper.ProductTotalPrice productTotalPrice) {
        BigDecimal result;
        BigDecimal bigDecimal = result = GeneralProductHelper.getHandler((BaseProduct)product).getTicketType(product) == TicketType.REFERRAL ? BookingHelper.calculateFee((BaseProduct)product, (ContractType)contractType) : BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)contractType).getTotal().add(BookingHelper.calculateFee((BaseProduct)product, (ContractType)contractType));
        if (productTotalPrice != null) {
            productTotalPrice.handle(product, contractType, paymentType);
        }
        return result;
    }

    public static BigDecimal getPaymentPrice(Collection<Reservation> reservations, ContractType contractType, PaymentType paymentType, BookingHelper.ProductTotalPrice productTotalPrice) {
        return reservations.stream().flatMap(r -> r.getProducts().stream()).map(p -> PaymentHelper.getPaymentPrice(p, contractType, paymentType, productTotalPrice)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public static BigDecimal getPaymentPrice(BookingFile bf, ContractType contractType, PaymentType paymentType, BookingHelper.ProductTotalPrice productTotalPrice) {
        return PaymentHelper.getPaymentPrice(bf.getReservations(), contractType, paymentType, productTotalPrice);
    }

    private static void recreateSplitFops(BaseProduct bp, ProductHandler<BaseProduct> handler, SplitPaymentSupport connector) {
        if (bp instanceof Product) {
            PaymentHelper.recreateAirSplitFops(bp, handler, connector);
        } else if (bp instanceof AeroexpressTicket) {
            PaymentHelper.recreateAeroexpressSplitFops(bp, handler, connector);
        } else if (bp instanceof InsuranceAccident) {
            PaymentHelper.recreateInsuranceSplitFops(bp, handler, connector);
        } else {
            CustomProductFopsHandler customHandler = ((PgHandlersRegistry)Environment.getPublished(PgHandlersRegistry.class)).getCustomProductFopHandler();
            if (customHandler != null) {
                customHandler.recreateCustomProductSplitFops(bp, handler, connector);
            }
        }
    }

    public static void recreateAirSplitFops(BaseProduct bp, ProductHandler<BaseProduct> handler, SplitPaymentSupport connector) {
        Product prod = (Product)bp;
        BigDecimal totalEqiuvalentFare = AirProductHelper.getTotalEquivalentFare((Product)prod);
        BigDecimal totalEquivalentFee = AirProductHelper.getEquivalentFeeAmount((Product)prod, (ContractType)ContractType.CLIENT);
        ArrayList<GeneralProductFop> fops = new ArrayList<GeneralProductFop>();
        GeneralProductFop supplierPaymentFop = new GeneralProductFop();
        supplierPaymentFop.setEquivalentAmount(totalEqiuvalentFare);
        supplierPaymentFop.setType(connector.getSplitSupplierPaymentType());
        supplierPaymentFop.setOperationDate(new Date());
        fops.add(supplierPaymentFop);
        GeneralProductFop agencyPaymentFop = new GeneralProductFop();
        agencyPaymentFop.setEquivalentAmount(totalEquivalentFee);
        agencyPaymentFop.setType(connector.getSplitAgencyPaymentType());
        agencyPaymentFop.setOperationDate(new Date());
        fops.add(agencyPaymentFop);
        for (AirProductContractRelationData relation : AirProductHelper.getContractRelations((Product)prod)) {
            if (GeneralProductHelper.getContractType((EntityReference)relation.getDescription()) == ContractType.VENDOR) continue;
            relation.getFops().clear();
        }
        GeneralProductHelper.updateFops((BaseProduct)prod, (ContractType)ContractType.CLIENT, fops);
        GeneralProductHelper.updateFops((BaseProduct)prod, (ContractType)ContractType.SUBAGENCY, fops);
    }

    public static void recreateInsuranceSplitFops(BaseProduct bp, ProductHandler<BaseProduct> handler, SplitPaymentSupport connector) {
        InsuranceAccident prod = (InsuranceAccident)bp;
        BigDecimal totalEqiuvalentFare = MiscUtil.guarded((BigDecimal)handler.getEquivalentFare((BaseProduct)prod));
        BigDecimal totalEquivalentFee = MiscUtil.guarded((BigDecimal)InsuranceAccidentHelper.getEquivalentFeeAmount((InsuranceAccident)prod));
        if (totalEquivalentFee != null) {
            totalEqiuvalentFare = totalEqiuvalentFare.add(totalEquivalentFee);
        }
        ArrayList<GeneralProductFop> fops = new ArrayList<GeneralProductFop>();
        GeneralProductFop agencyPaymentFop = new GeneralProductFop();
        agencyPaymentFop.setEquivalentAmount(totalEqiuvalentFare);
        agencyPaymentFop.setType(connector.getSplitAgencyPaymentType());
        agencyPaymentFop.setOperationDate(new Date());
        fops.add(agencyPaymentFop);
        InsuranceAccidentHelper.getClientFops((InsuranceAccident)prod).clear();
        InsuranceAccidentHelper.getSubagentFops((InsuranceAccident)prod, (boolean)true).clear();
        GeneralProductHelper.updateFops((BaseProduct)prod, (ContractType)ContractType.CLIENT, fops);
        GeneralProductHelper.updateFops((BaseProduct)prod, (ContractType)ContractType.SUBAGENCY, fops);
    }

    private static void recreateAeroexpressSplitFops(BaseProduct bp, ProductHandler<BaseProduct> handler, SplitPaymentSupport connector) {
        AeroexpressTicket prod = (AeroexpressTicket)bp;
        BigDecimal totalEqiuvalentFare = handler.getEquivalentFare((BaseProduct)prod);
        BigDecimal totalEquivalentFee = AeroexpressTicketHelper.getEquivalentFeeAmount((AeroexpressTicket)prod);
        if (totalEquivalentFee != null) {
            totalEqiuvalentFare = totalEqiuvalentFare.add(totalEquivalentFee);
        }
        ArrayList<GeneralProductFop> fops = new ArrayList<GeneralProductFop>();
        GeneralProductFop agencyPaymentFop = new GeneralProductFop();
        agencyPaymentFop.setEquivalentAmount(totalEqiuvalentFare);
        agencyPaymentFop.setType(connector.getSplitAgencyPaymentType());
        agencyPaymentFop.setOperationDate(new Date());
        fops.add(agencyPaymentFop);
        AeroexpressTicketHelper.getSubagentFops((AeroexpressTicket)prod, (boolean)true).clear();
        AeroexpressTicketHelper.getClientFops((AeroexpressTicket)prod).clear();
        GeneralProductHelper.updateFops((BaseProduct)prod, (ContractType)ContractType.CLIENT, fops);
        GeneralProductHelper.updateFops((BaseProduct)prod, (ContractType)ContractType.SUBAGENCY, fops);
    }

    private static SalesContext createSalesContext(Reservation reservation) {
        SalesContext result = new SalesContext();
        result.setAgency(reservation.getBookingFile().getAgency());
        result.setSubagency(reservation.getSubagency());
        result.setClient(reservation.getBookingFile().getCustomerProfile());
        if (reservation.getBookingFile().getCustomer() != null) {
            result.setCustomer(reservation.getBookingFile().getCustomer().getProfile());
        }
        result.setSalesPoint(reservation.getSalesPoint());
        result.setAgent(reservation.getBookingAgent());
        return result;
    }

    public static void checkSegmentsForIssuing(EntityContainer<BookingFile> bfCtr) throws Exception {
        try {
            Reservation baseProductReservation = BookingHelper.getBaseProductReservation((BookingFile)((BookingFile)bfCtr.getEntity()), (boolean)true);
            GdsName gds = CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)baseProductReservation);
            Reservation res = null;
            for (Reservation reserv : ((BookingFile)bfCtr.getEntity()).getReservations()) {
                if (CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)reserv) != gds) continue;
                res = reserv;
                break;
            }
            if (gds != GdsName.SABRE) {
                return;
            }
            if (res == null) {
                throw new Exception(String.format("no %s reservation in booking file", gds));
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("BOOKING_FILE", bfCtr);
            data.put("SALES_CONTEXT", PaymentHelper.createSalesContext(res));
            IntegrationBusFacade.get().getRequestReplyAdapter("midoffice:check-booking").processSync(data);
        }
        catch (Throwable t) {
            log.error("checkSegmentsForIssuing exception", t);
            throw new Exception("segments not confirmed for issuing");
        }
    }

    public static boolean reprice(EntityContainer<BookingFile> bfCtr, List<Message> messages) throws Exception {
        return PaymentHelper.reprice(bfCtr, messages, null);
    }

    public static boolean reprice(EntityContainer<BookingFile> bfCtr, List<Message> messages, PaymentType paymentType) throws Exception {
        EntityContainer bookingFile = bfCtr;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("BOOKING_FILE", bookingFile);
        data.put("SALES_CONTEXT", PaymentHelper.createSalesContext((Reservation)((BookingFile)bookingFile.getEntity()).getReservations().get(0)));
        if (paymentType != null) {
            Fop fop = new Fop();
            fop.setType(paymentType);
            data.put("FOP", fop);
        }
        BigDecimal oldTotal = BookingHelper.getTotalPrice((BookingFile)((BookingFile)bookingFile.getEntity()), (ContractType)ContractType.CLIENT);
        IntegrationBusFacade.get().getRequestReplyAdapter("midoffice:reprice-booking").processSync(data);
        bookingFile = (EntityContainer)data.get("BOOKING_FILE");
        BigDecimal newTotal = BookingHelper.getTotalPrice((BookingFile)((BookingFile)bookingFile.getEntity()), (ContractType)ContractType.CLIENT);
        return !oldTotal.equals(newTotal);
    }

    public static BigDecimal getTotalFee(BookingFile bookingFile, ContractType contractType) {
        Objects.requireNonNull(bookingFile);
        return PaymentHelper.getTotalFee(bookingFile.getReservations(), contractType);
    }

    public static BigDecimal getTotalFee(Collection<Reservation> reservations, ContractType contractType) {
        return reservations.stream().filter(Objects::nonNull).flatMap(r -> r.getProducts().stream()).map(baseProduct -> BookingHelper.calculateFee((BaseProduct)baseProduct, (ContractType)contractType)).reduce(BigDecimal.ZERO, (a, b) -> a.add((BigDecimal)b));
    }

    public static boolean isAllIssued(BookingFile bookingFile) {
        Optional<Product> notSell = BookingStreamHelper.getProductsStream((BookingFile)bookingFile, Product.class).filter(product -> ProductStatus.SELL != product.getStatus()).findFirst();
        return !notSell.isPresent();
    }

    public static boolean isAllIssued(Collection<Reservation> reservations) {
        Optional<Product> notSell = BookingStreamHelper.getProductsStream(reservations.stream().flatMap(r -> r.getProducts().stream()), Product.class).filter(product -> ProductStatus.SELL != product.getStatus()).findFirst();
        return !notSell.isPresent();
    }

    public static boolean allProductsHaveBookingStatus(BookingFile bookingFile) {
        for (Reservation reservation : bookingFile.getReservations()) {
            for (BaseProduct bp : reservation.getProducts()) {
                if (bp instanceof Product && ((Product)bp).getStatus() != ProductStatus.BOOKING) {
                    return false;
                }
                if (!(bp instanceof InsuranceAccident) || ((InsuranceAccident)bp).getStatus() == ProductStatus.BOOKING) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean hasSoldProducts(BookingFile bookingFile) {
        for (Reservation reservation : bookingFile.getReservations()) {
            for (BaseProduct bp : reservation.getProducts()) {
                if (bp instanceof Product && ((Product)bp).getStatus() == ProductStatus.SELL) {
                    return true;
                }
                if (!(bp instanceof InsuranceAccident) || ((InsuranceAccident)bp).getStatus() != ProductStatus.SELL) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasSoldProducts(Collection<Reservation> reservations) {
        return reservations.stream().flatMap(r -> r.getProducts().stream()).anyMatch(p -> GeneralProductHelper.getStatus((BaseProduct)p) == ProductStatus.SELL);
    }

    public static List<BookingFileIndex> searchBookingFile(String pnr, boolean toBePayed) throws Exception {
        SearchQuery sq = new SearchQuery();
        sq.getCriteria().getCriterions().add(SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)pnr));
        if (toBePayed) {
            sq.getCriteria().getCriterions().add(SearchCriterion.eq((String)BookingFileIndex.Property.workflowStatus.name(), (Object)WorkflowStatus.TO_BE_PAYED));
        }
        List result = EntityStorage.get().search(BookingFileIndex.class, sq).getData();
        return result;
    }

    public static BigDecimal calculateSumToRefund(List<BaseProduct> products) {
        BigDecimal sumToRefund = BigDecimal.ZERO;
        for (BaseProduct baseProduct : products) {
            if (baseProduct instanceof Product) {
                log.error("Cannot refund air tickets - wrong input parameters!");
                continue;
            }
            BigDecimal productPrice = PaymentHelper.getProductPrice(baseProduct, ContractType.CLIENT);
            sumToRefund = sumToRefund.add(productPrice);
        }
        return sumToRefund;
    }

    public static BigDecimal getProductPrice(BaseProduct baseProduct, ContractType contractType) {
        BigDecimal productPrice = PaymentHelper.getPaymentPrice(baseProduct, contractType, null, null);
        return productPrice;
    }

    public static BigDecimal getProductsFeeSum(List<Product> feeProducts, ContractType contractType) {
        BigDecimal totalFee = BigDecimal.ZERO;
        for (Product product : feeProducts) {
            totalFee = totalFee.add(BookingHelper.calculateFee((BaseProduct)product, (ContractType)contractType));
        }
        return totalFee;
    }

    public static List<PgPaymentIndex> searchPayments(EntityReference<? extends BaseEntity> entityReference) {
        return PaymentHelper.searchPayments(entityReference, null);
    }

    public static List<PgPaymentIndex> searchPayments(EntityReference<? extends BaseEntity> entityReference, String paymentId) {
        SearchQuery sq = new SearchQuery();
        sq.getCriteria().getCriterions().add(SearchCriterion.eq((String)PgPaymentIndex.Property.entity.name(), entityReference));
        if (paymentId != null) {
            sq.getCriteria().getCriterions().add(SearchCriterion.eq((String)PgPaymentIndex.Property.paymentId.name(), (Object)paymentId));
        }
        return EntityStorage.get().search(PgPaymentIndex.class, sq).getData();
    }

    public static PGConnector getPgConnector(PaymentType ptName, boolean withSplitSupport) {
        for (PGConnector connector : ((PGConnectorRegistry)Environment.getPublished(PGConnectorRegistry.class)).getAll()) {
            if (!connector.getConnectorInfo().getSupportedPaymentTypes().contains(ptName) || (!withSplitSupport || !(connector instanceof SplitPaymentSupport)) && withSplitSupport) continue;
            return connector;
        }
        return null;
    }

    public static PGConnector getPgConnector(PaymentType ptName) {
        return PaymentHelper.getPgConnector(ptName, false);
    }

    public static EntityContainer<BookingFile> getBookingFileContainer(Payment payment) {
        EntityContainer bfCtr = EntityStorage.get().resolve(payment.getEntity());
        return bfCtr;
    }

    public static BookingFile getBookingFile(Payment payment) {
        return (BookingFile)PaymentHelper.getBookingFileContainer(payment).getEntity();
    }

    public static String getSabreFareAndPnr(PaymentInitiationResult result, ValueHolder<BigDecimal> totalSabre) throws Exception {
        BigDecimal sum = (BigDecimal)totalSabre.getValue();
        String resultPnr = "";
        BookingFile bookingFile = PaymentHelper.getBookingFile(result.getPayment());
        for (Reservation res : bookingFile.getReservations()) {
            if (CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)res) == GdsName.SABRE) {
                resultPnr = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)res);
            }
            for (BaseProduct prod : res.getProducts()) {
                if (!(prod instanceof Product)) continue;
                Product product = (Product)prod;
                if (CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)res) != GdsName.SABRE) continue;
                sum = sum.add(AirProductHelper.getEquivalentFare((Product)product));
                BigDecimal taxesEquivalentAmount = AirProductHelper.calculateTaxesEquivalentAmount((Product)product);
                if (taxesEquivalentAmount == null) continue;
                sum = sum.add(taxesEquivalentAmount);
            }
        }
        totalSabre.setValue((Object)sum);
        return resultPnr;
    }

    public static void deleteBillingTransaction(EntityContainer<BillingTransaction> billingTransaction) {
        try {
            EntityStorage.get().delete(billingTransaction);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    public static TreeMap<PaymentType, List<GeneralProductFop>> getFops(EntityContainer<BookingFile> bfCtr, ContractType contractType) throws Exception {
        TreeMap<PaymentType, List<GeneralProductFop>> result = new TreeMap<PaymentType, List<GeneralProductFop>>();
        Set<PaymentType> allowedPaymentTypes = ((AllowedPaymentTypesHandler)Environment.getPublished(AllowedPaymentTypesHandler.class)).getAllowedPaymentTypes(bfCtr);
        SplitPaymentRegistry splitPaymentRegistry = (SplitPaymentRegistry)Environment.getPublished(SplitPaymentRegistry.class);
        Iterator<PaymentType> iterator = allowedPaymentTypes.iterator();
        while (iterator.hasNext()) {
            PGConnector pgConnector;
            boolean canUseSplitScheme;
            PaymentType paymentType = iterator.next();
            boolean isSplitPayment = splitPaymentRegistry.isSplitPayment(paymentType);
            if (!isSplitPayment || (canUseSplitScheme = ((SplitPaymentSupport)(pgConnector = PaymentHelper.getPgConnector(paymentType, true))).canUseSplitScheme(bfCtr))) continue;
            iterator.remove();
        }
        for (PaymentType paymentType : allowedPaymentTypes) {
            EntityContainer cloneCtr = new EntityContainer(BookingFile.class);
            XCloneModelHelper.copy(bfCtr, (BaseEntity)cloneCtr, (boolean)false);
            EntityReference agency = null;
            EntityReference agent = null;
            EntityReference salesPoint = null;
            Date issueDate = null;
            PGConnector pgConnector = null;
            boolean isSplitPayment = splitPaymentRegistry.isSplitPayment(paymentType);
            boolean isUpdateSplitFops = false;
            if (isSplitPayment) {
                pgConnector = PaymentHelper.getPgConnector(paymentType, true);
                isUpdateSplitFops = ((SplitPaymentSupport)pgConnector).canUseSplitScheme(bfCtr);
            }
            for (Reservation res : ((BookingFile)cloneCtr.getEntity()).getReservations()) {
                for (BaseProduct bp : res.getProducts()) {
                    ProductHandler handler = HandlersRegistry.get().findProductHandler(bp.getClass());
                    if (isUpdateSplitFops) {
                        PaymentHelper.recreateSplitFops(bp, (ProductHandler<BaseProduct>)handler, (SplitPaymentSupport)pgConnector);
                    } else {
                        GeneralProductHelper.updateAllFOPs((BaseProduct)bp, (PaymentType)paymentType);
                        List vendorFops = GeneralProductHelper.getUnmodifiableFops((BaseProduct)bp, (ContractType)ContractType.VENDOR);
                        for (GeneralProductFop item : vendorFops) {
                            item.setType(PaymentType.INVOICE);
                        }
                        GeneralProductHelper.updateFops((BaseProduct)bp, (ContractType)ContractType.VENDOR, (List)vendorFops);
                    }
                    if (agency == null) {
                        agency = GeneralProductHelper.getAgency((BaseProduct)bp);
                    }
                    if (agent == null) {
                        agent = handler.findIssuingAgent(bp);
                    }
                    if (salesPoint == null) {
                        salesPoint = handler.findSalesPoint(bp);
                    }
                    if (issueDate != null) continue;
                    issueDate = handler.findIssueDate(bp);
                }
            }
            if (agency == null) {
                agency = ((BookingFile)bfCtr.getEntity()).getAgency();
            }
            ArrayList messages = new ArrayList();
            HashMap params = new HashMap();
            ((BookingCommissionsCalculator)Environment.getPublished(BookingCommissionsCalculator.class)).applyRules(cloneCtr, true, true, messages, params, null);
            if (log.isDebugEnabled()) {
                log.debug(String.format("Applied rules to booking file %s, contract type is %s, payment type is %s, booking file: %s, messages: %s", ((BookingFile)cloneCtr.getEntity()).getNumber(), contractType, paymentType, XSUtil.toString((XSSerializable)cloneCtr.getEntity()), MessageHelper.toString(messages)));
            }
            ArrayList fopList = new ArrayList();
            for (Reservation res : ((BookingFile)cloneCtr.getEntity()).getReservations()) {
                for (BaseProduct bp : res.getProducts()) {
                    ProductHandler handler = HandlersRegistry.get().findProductHandler(bp.getClass());
                    List fops = GeneralProductHelper.getFops((List)handler.getUnmodifiableContractRelations(bp), (ContractType)ContractType.SUBAGENCY);
                    if (fops == null || fops.isEmpty()) continue;
                    fopList.addAll(fops);
                }
            }
            result.put(paymentType, fopList);
        }
        log.debug(String.format("Total prices for booking file %s, contract type %s are %s", ((BookingFile)bfCtr.getEntity()).getNumber(), contractType, result));
        return result;
    }

    public static int compareTo(BigDecimal value1, BigDecimal value2, int scale) {
        BigDecimal v1 = value1.setScale(scale, RoundingMode.HALF_UP);
        BigDecimal v2 = value2.setScale(scale, RoundingMode.HALF_UP);
        return v1.compareTo(v2);
    }

    public static Set<GdsName> getGdsSupportingSplitPayments() {
        PgHandlersRegistry pgRegistry = (PgHandlersRegistry)Environment.getPublished(PgHandlersRegistry.class);
        return pgRegistry.getSplitPaymentGdsSupporting();
    }

    public static Product getSplitProduct(BookingFile bookingFile) {
        if (bookingFile == null) {
            return null;
        }
        Reservation baseProductReservation = BookingHelper.getBaseProductReservation((BookingFile)bookingFile);
        if (baseProductReservation == null || !PaymentHelper.getGdsSupportingSplitPayments().contains(CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)baseProductReservation)) || !(baseProductReservation.getProducts().get(0) instanceof Product)) {
            return null;
        }
        Product product = (Product)baseProductReservation.getProducts().get(0);
        return product;
    }

    public static Product getSplitProduct(Reservation reservation) {
        if (reservation == null || !PaymentHelper.getGdsSupportingSplitPayments().contains(CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)reservation)) || reservation.getProducts().isEmpty() || !(reservation.getProducts().get(0) instanceof Product)) {
            return null;
        }
        return (Product)AirProductHelper.getAirProductsList((Reservation)reservation).get(0);
    }

    public static String getAirlineHint(BookingFile bfCtr) {
        Product product = PaymentHelper.getSplitProduct(bfCtr);
        EntityContainer spCtr = EntityStorage.get().resolve(product.getSalesPoint());
        String clsName = System.getProperty("accepted-cards-from-rules-holder.className");
        if (!TextUtil.isBlank((String)clsName) && spCtr != null) {
            try {
                AcceptedCardsProvider provider = (AcceptedCardsProvider)PaymentHelper.class.getClassLoader().loadClass(clsName).newInstance();
                return provider.getHint(product.getCarrier().getCode(), bfCtr, AirProductHelper.getSubagency((Product)product));
            }
            catch (InstantiationException e) {
                log.error("", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error("", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                log.error("", (Throwable)e);
            }
        } else if (spCtr != null) {
            for (SalesPointAirlineInfo info : ((SalesPoint)spCtr.getEntity()).getAirlineInfos()) {
                if (!info.getAirline().getCode().equals(product.getCarrier().getCode())) continue;
                return info.getHint();
            }
        }
        return null;
    }

    public static Card convertCardDetailsToCard(CardTransactionDetails details) {
        if (details != null) {
            Card card = new Card();
            card.setExpiration(details.getExpiration());
            card.setNameOnCard(details.getNameOnCard());
            card.setNumber(details.getNumber());
            card.setRemarks(details.getRemarks());
            card.setSecurityCode(details.getSecurityCode());
            card.setVendor(details.getVendor());
            return card;
        }
        return null;
    }

    public static Set<AirlineCard> getAcceptedCards(BookingFile bfCtr) {
        Product splitProduct = PaymentHelper.getSplitProduct(bfCtr);
        if (splitProduct == null) {
            return new HashSet<AirlineCard>();
        }
        DictionaryReference carrier = splitProduct.getCarrier();
        Airline airline = (Airline)DictionaryCache.get().resolveReference(carrier);
        if (airline != null && airline.getAcceptableCards() != null && !airline.getAcceptableCards().isEmpty()) {
            return airline.getAcceptableCards();
        }
        EntityContainer spCtr = EntityStorage.get().resolve(splitProduct.getSalesPoint());
        String clsName = System.getProperty("accepted-cards-from-rules-holder.className");
        if (!TextUtil.isBlank((String)clsName) && spCtr != null) {
            try {
                AcceptedCardsProvider provider = (AcceptedCardsProvider)PaymentHelper.class.getClassLoader().loadClass(clsName).newInstance();
                return provider.getAcceptedCards(splitProduct.getCarrier().getCode(), bfCtr, AirProductHelper.getSubagency((Product)splitProduct));
            }
            catch (InstantiationException e) {
                log.error("", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error("", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                log.error("", (Throwable)e);
            }
        } else if (spCtr != null) {
            for (SalesPointAirlineInfo info : ((SalesPoint)spCtr.getEntity()).getAirlineInfos()) {
                if (!info.getAirline().getCode().equals(splitProduct.getCarrier().getCode())) continue;
                return info.getAcceptableCards();
            }
        }
        return new HashSet<AirlineCard>();
    }

    public static Collection<AirlineCard> getAcceptedCards(Collection<Reservation> reservations) {
        Set<AirlineCard> acceptedCards = null;
        for (Reservation reservation : reservations) {
            Set<AirlineCard> ac = PaymentHelper.getAcceptedCards(reservation);
            Set<Object> set = acceptedCards != null ? acceptedCards.stream().filter(ac::contains).collect(Collectors.toSet()) : ac;
            acceptedCards = set;
            if (!acceptedCards.isEmpty()) continue;
            break;
        }
        return acceptedCards != null ? acceptedCards : Collections.emptySet();
    }

    public static Set<AirlineCard> getAcceptedCards(Reservation reservation) {
        if (null == reservation) {
            return new HashSet<AirlineCard>();
        }
        Product splitProduct = PaymentHelper.getSplitProduct(reservation);
        if (splitProduct == null) {
            return new HashSet<AirlineCard>();
        }
        DictionaryReference carrier = splitProduct.getCarrier();
        Airline airline = (Airline)DictionaryCache.get().resolveReference(carrier);
        if (airline != null && airline.getAcceptableCards() != null && !airline.getAcceptableCards().isEmpty()) {
            return airline.getAcceptableCards();
        }
        EntityContainer spCtr = EntityStorage.get().resolve(splitProduct.getSalesPoint());
        String clsName = System.getProperty("accepted-cards-from-rules-holder.className");
        if (!TextUtil.isBlank((String)clsName) && spCtr != null) {
            try {
                AcceptedCardsProvider provider = (AcceptedCardsProvider)PaymentHelper.class.getClassLoader().loadClass(clsName).newInstance();
                return provider.getAcceptedCards(splitProduct);
            }
            catch (InstantiationException e) {
                log.error("", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error("", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                log.error("", (Throwable)e);
            }
        } else if (spCtr != null) {
            for (SalesPointAirlineInfo info : ((SalesPoint)spCtr.getEntity()).getAirlineInfos()) {
                if (!info.getAirline().getCode().equals(splitProduct.getCarrier().getCode())) continue;
                return info.getAcceptableCards();
            }
        }
        return new HashSet<AirlineCard>();
    }

    public static boolean canUseSplitScheme(BookingFile bookingFile) {
        Product splitProduct = PaymentHelper.getSplitProduct(bookingFile);
        if (splitProduct == null) {
            return false;
        }
        if (splitProduct.isSubsidizedTariff()) {
            log.info("canUseSplitScheme=false, since the product's subsidized");
            return false;
        }
        Set<AirlineCard> acceptedCards = PaymentHelper.getAcceptedCards(bookingFile);
        return !acceptedCards.isEmpty();
    }

    public static boolean canUseSplitScheme(Reservation reservation) {
        Product splitProduct = PaymentHelper.getSplitProduct(reservation);
        if (splitProduct == null) {
            return false;
        }
        if (splitProduct.isSubsidizedTariff()) {
            log.info("canUseSplitScheme=false, since the product's subsidized");
            return false;
        }
        Set<AirlineCard> acceptedCards = PaymentHelper.getAcceptedCards(reservation);
        return !acceptedCards.isEmpty();
    }

    public static String getAirlineAcceptedCardsHint(BookingFile bf, EntityReference<SalesPoint> salesPoint) {
        try {
            Product sabreProduct = PaymentHelper.getSplitProduct(bf);
            if (sabreProduct == null) {
                return "";
            }
            EntityContainer spCtr = EntityStorage.get().resolve(salesPoint);
            if (spCtr != null && spCtr.getEntity() != null) {
                for (SalesPointAirlineInfo info : ((SalesPoint)spCtr.getEntity()).getAirlineInfos()) {
                    if (!info.getAirline().getCode().equals(sabreProduct.getCarrier().getCode()) || TextUtil.isBlank((String)info.getHint())) continue;
                    return info.getHint();
                }
            }
            return "";
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "";
        }
    }

    public static boolean isDayChanged(Payment payment, Date now) {
        Calendar paymentDate = Calendar.getInstance();
        paymentDate.setTime(payment.getCreated());
        Calendar nowDate = Calendar.getInstance();
        nowDate.setTime(now);
        int diffDay = nowDate.get(6) - paymentDate.get(6);
        return diffDay != 0;
    }

    public static List<PGConnectorInfo> getConnectorsInfo() {
        return ((PGConnectorRegistry)Environment.getPublished(PGConnectorRegistry.class)).getAll().stream().map(PGConnector::getConnectorInfo).collect(Collectors.toList());
    }

    public static <E extends BaseEntity> EntityReference<E> entityReference(Payment payment, Class<E> cls) {
        if (Objects.isNull(payment) || Objects.isNull(cls)) {
            return null;
        }
        EntityReference entity = payment.getEntity();
        if (Objects.isNull(entity)) {
            return null;
        }
        if (!cls.equals(entity.getType())) {
            return null;
        }
        return entity;
    }
}

