/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg;

import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class PaymentHelperTest
extends ModelTestBase {
    @Test
    public void compareTo() throws Exception {
        Assert.assertEquals((long)PaymentHelper.compareTo(new BigDecimal("10"), new BigDecimal("10"), 2), (long)0L);
        Assert.assertEquals((long)PaymentHelper.compareTo(new BigDecimal("1"), new BigDecimal("2"), 2), (long)-1L);
        Assert.assertEquals((long)PaymentHelper.compareTo(new BigDecimal("4"), new BigDecimal("2"), 2), (long)1L);
        Assert.assertEquals((long)PaymentHelper.compareTo(new BigDecimal("116553.00043125009"), new BigDecimal("116553"), 2), (long)0L);
        Assert.assertEquals((long)PaymentHelper.compareTo(new BigDecimal(12587.9999886), new BigDecimal("12588.00"), 2), (long)0L);
    }

    @Test
    public void isDayChanged() throws Exception {
        Payment payment = new Payment();
        Assert.assertFalse((boolean)PaymentHelper.isDayChanged(payment, new Date()));
        Calendar c = Calendar.getInstance();
        c.add(5, 1);
        Payment payment2 = new Payment();
        Assert.assertTrue((boolean)PaymentHelper.isDayChanged(payment2, c.getTime()));
        SimpleDateFormat inputDateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm+s:SSSS");
        Date date = inputDateFormatter.parse("2011-11-11T22:33+0:400");
        Payment payment3 = new Payment();
        payment3.setCreated(date);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(date);
        c2.add(10, 1);
        Assert.assertFalse((boolean)PaymentHelper.isDayChanged(payment3, c2.getTime()));
        inputDateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm+s:SSSS");
        date = inputDateFormatter.parse("2011-11-11T22:33+0:400");
        payment3 = new Payment();
        payment3.setCreated(date);
        c2 = Calendar.getInstance();
        c2.setTime(date);
        c2.add(10, 1);
        Assert.assertFalse((boolean)PaymentHelper.isDayChanged(payment3, c2.getTime()));
    }
}

