/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.pg.PGException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentQueueManager {
    static final long DEFAULT_QUEUE_PERIOD = 86400000L;
    private static final String TO_TAG_PREFIX = "paymentTO.";
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final PgName pgName;
    private Long queuePeriod = null;

    public PaymentQueueManager(Long queuePeriod, PgName pgName) {
        this(pgName);
        this.queuePeriod = queuePeriod;
    }

    public PaymentQueueManager(PgName pgName) {
        if (pgName == null) {
            throw Xeption.forDeveloper((String)"null pgName", (Object[])new Object[0]);
        }
        this.pgName = pgName;
    }

    public PgName getPgName() {
        return this.pgName;
    }

    public void updateToQueue(Payment payment) {
        block2: {
            try {
                TemporalObject temporalObject = this.getTemporalObject(payment.getPaymentId());
                temporalObject.setData(XSUtil.toString((XSSerializable)payment).getBytes());
                temporalObject.setExpired(this.getExpired());
                LogicalStorage.get().getAssetStorage().save((BaseAsset)temporalObject);
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) break block2;
                this.log.error("", (Throwable)e);
            }
        }
    }

    public void addToQueue(Payment payment) {
        TemporalObject temporalObject = this.getTemporalObject(payment.getPaymentId());
        if (temporalObject != null) {
            this.updateExistingPayment(temporalObject, payment);
            this.log.info("payment already in queue, " + payment);
        } else {
            this.saveNewTemporalObject(payment);
        }
    }

    public void removeFromQueue(String paymentId) {
        try {
            this.log.info(String.format("remove payment %s from the queue", paymentId));
            TemporalObject to = this.getTemporalObject(paymentId);
            if (to == null) {
                this.log.warn(String.format("payment %s not found in queue", paymentId));
                return;
            }
            LogicalStorage.get().getAssetStorage().delete((BaseAsset)to);
            this.log.trace(String.format("Payment [uid=%s] removed from the storage", paymentId));
        }
        catch (Exception ex) {
            this.log.error(String.format("failed removing payment %s from queue", paymentId), (Throwable)ex);
            throw new PGException("payment queue error", ex);
        }
    }

    public void removeFromQueue(Payment payment) {
        this.removeFromQueue(payment.getPaymentId());
    }

    public boolean isInQueue(Payment payment) {
        try {
            return this.getTemporalObject(payment.getPaymentId()) != null;
        }
        catch (Exception ex) {
            this.log.error(String.format("failed checking if a payment %s is in a queue", payment.getPaymentId()), (Throwable)ex);
            throw new PGException("isInQueue error", ex);
        }
    }

    public TemporalObject getTemporalObject(String paymentId) {
        try {
            SearchQuery query = new SearchQuery();
            String tagValue = this.createTagValue();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TemporalObject.Property.tag.name(), (Object)tagValue));
            this.log.trace(String.format("getTemporalObject [uid=%s,tag=%s]", paymentId, tagValue));
            for (TemporalObject obj : LogicalStorage.get().getAssetStorage().search(TemporalObject.class, query).getData()) {
                if (!obj.getUid().equals(paymentId)) continue;
                this.log.trace(String.format("Get Temporal Object [uid=%s] - Ok", obj.getUid()));
                return obj;
            }
            return null;
        }
        catch (Exception e) {
            throw new PGException("getTemporalObject error", e);
        }
    }

    public Payment getFromQueue(String paymentId) {
        try {
            this.log.info(String.format("get payment by paymentId [%s] from queue", paymentId));
            TemporalObject to = this.getTemporalObject(paymentId);
            if (to == null) {
                this.log.warn(String.format("payment %s not found in queue", paymentId));
                return null;
            }
            Payment payment = new Payment();
            XUtil.fromString((String)new String(to.getData()), (XSerializable)payment);
            this.log.info(String.format("get %s by id [%s] from queue", payment, paymentId));
            return payment;
        }
        catch (Exception ex) {
            this.log.error(String.format("getting payment %s from queue", paymentId), (Throwable)ex);
            throw new PGException("getFromQueue error", ex);
        }
    }

    private void saveNewTemporalObject(Payment payment) {
        try {
            TemporalObject tempObj = new TemporalObject(payment.getPaymentId());
            tempObj.setExpired(this.getExpired());
            String tagValue = this.createTagValue();
            tempObj.setTag(tagValue);
            tempObj.setData(XSUtil.toString((XSSerializable)payment).getBytes());
            LogicalStorage.get().getAssetStorage().save((BaseAsset)tempObj);
            this.log.trace(String.format("Payment [uid=%s,tag=%s] saved in the storage", payment.getPaymentId(), tagValue));
        }
        catch (Exception ex) {
            this.log.error(String.format("failed adding payment %s to queue", payment.getPaymentId()), (Throwable)ex);
            throw new PGException("saveNewTemporalObject error", ex);
        }
    }

    private String createTagValue() {
        return TO_TAG_PREFIX + this.pgName.name();
    }

    private void updateExistingPayment(TemporalObject temporalObject, Payment payment) {
        try {
            EntityReference entity = payment.getEntity();
            BigDecimal newTotalPrice = payment.getAmount();
            Payment temporalPayment = new Payment();
            XUtil.fromString((String)new String(temporalObject.getData()), (XSerializable)temporalPayment);
            BigDecimal oldPrice = temporalPayment.getAmount();
            if (newTotalPrice.compareTo(oldPrice) != 0) {
                this.log.warn(String.format("Booking file [%s] price's been changed from [%.2f] to [%.2f] -> update temporal object", entity.getCaption(), oldPrice, newTotalPrice));
                temporalObject.setData(XSUtil.toString((XSSerializable)payment).getBytes());
            }
            temporalObject.setExpired(this.getExpired());
            LogicalStorage.get().getAssetStorage().save((BaseAsset)temporalObject);
        }
        catch (Exception e) {
            this.log.error("", (Throwable)e);
        }
    }

    private Date getExpired() {
        Long period = Optional.ofNullable(this.queuePeriod).filter(aLong -> aLong != 0L).orElse(86400000L);
        return MiscUtil.addToDate((Date)new Date(), (int)period.intValue(), (int)14);
    }
}

