/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg;

import com.gridnine.bof.midoffice.helper.MidofficeHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.BaseTransactionDetails;
import com.gridnine.xtrip.common.model.system.BillingTransaction;
import com.gridnine.xtrip.common.model.system.BillingTransactionCategory;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.common.model.system.BillingTransactionType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.pg.model.PgPaymentIndex;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import com.gridnine.xtrip.server.pg.CreateFopsHandler;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.PaymentQueueManager;
import com.gridnine.xtrip.server.pg.PgTotalPriceProvider;
import com.gridnine.xtrip.server.pg.handlers.PaymentStatusHandler;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentSucceedHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected Payment payment;
    private PaymentStatusHandler statusHandler;
    private PgTotalPriceProvider totalPriceProvider;
    private List<Message> messages;
    private SalesContext salesContext;
    private EntityContainer<BookingFile> bookingFileCtr;
    private CreateFopsHandler createFopsHandler;

    public void process(PaymentStatusHandler statusHandler, PaymentQueueManager queueManager, PgTotalPriceProvider totalPriceProvider, Payment payment, List<Message> messages, SalesContext salesContext) throws PGException {
        this.totalPriceProvider = Objects.requireNonNull(totalPriceProvider, "null totalPriceProvider");
        this.payment = Objects.requireNonNull(payment, "null payment");
        this.messages = Objects.requireNonNull(messages, "null messages");
        this.statusHandler = statusHandler;
        this.salesContext = salesContext;
        try {
            this.internalProcess();
        }
        catch (Exception e) {
            this.log.error("payment succeed error", (Throwable)e);
            throw new PGException("payment succeed error", e);
        }
        finally {
            queueManager.removeFromQueue(payment);
        }
    }

    private void internalProcess() throws Exception {
        if (this.isBookingFileBeingPayed()) {
            this.processBookingFile();
        } else if (this.isCreateBillingTransaction()) {
            this.createPaymentBillingTransaction();
        }
        if (Objects.nonNull(this.statusHandler)) {
            this.statusHandler.paymentSucceeded(this.payment, this.salesContext, this.messages, this.bookingFileCtr);
        }
        this.setPaymentStatus();
        this.savePayment();
    }

    private boolean isCreateBillingTransaction() {
        return Objects.nonNull(this.payment.getPayee()) && Objects.nonNull(this.payment.getPayer());
    }

    private void processBookingFile() throws Exception {
        if (this.log.isInfoEnabled()) {
            this.log.info(String.format("%s succeded [bookingNumber=%s]", this.payment, TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)this.bookingFileCtr.getEntity()))));
        }
        this.validatePaidPrice();
        if (Objects.isNull(this.createFopsHandler)) {
            this.createFopsHandler = new CreateFopsHandler();
        }
        this.createFopsHandler.prepare(this.bookingFileCtr, this.payment).processAndSave();
    }

    private void validatePaidPrice() {
        BigDecimal totalPrice = this.totalPriceProvider.get((EntityReference<BookingFile>)this.bookingFileCtr.toReference(), PaymentHelper.getReservations((BookingFile)this.bookingFileCtr.getEntity(), (Collection<String>)this.payment.getReservations()), this.payment.getPaymentType());
        if (!this.isPayedPricesValid(totalPrice)) {
            this.payment.setStatus(PaymentStatus.ERROR);
            throw new PGException("prices not valid");
        }
    }

    private boolean isBookingFileBeingPayed() {
        if (Objects.nonNull(this.bookingFileCtr)) {
            return true;
        }
        EntityReference<BookingFile> bookingFileRef = PaymentHelper.entityReference(this.payment, BookingFile.class);
        if (Objects.isNull(bookingFileRef)) {
            return false;
        }
        this.bookingFileCtr = EntityStorageHelper.resolve(bookingFileRef);
        return true;
    }

    private boolean isPayedPricesValid(BigDecimal totalPrice) {
        BigDecimal paymentTotal;
        if (Objects.isNull(totalPrice)) {
            throw Xeption.forEndUser((String)String.format("%s no price available", this.payment), (Object[])new Object[0]);
        }
        BigDecimal bookingFileTotal = this.round(totalPrice);
        if (this.equals(bookingFileTotal, paymentTotal = this.round(this.payment.getAmount()))) {
            return true;
        }
        Message errorMessage = MessageHelper.createErrorMessage((String)"\u0421\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 {0} \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0441\u0443\u043c\u043c\u0435 \u0437\u0430\u043a\u0430\u0437\u0430 {1}", (Object[])new Object[]{paymentTotal, bookingFileTotal});
        this.messages.add(errorMessage);
        this.log.error(String.format("booking file %s payment sum %s is not equal to booking sum %s", ((BookingFile)this.bookingFileCtr.getEntity()).getNumber(), paymentTotal, bookingFileTotal));
        SysLogHelper.audit((EntityReference)this.bookingFileCtr.toReference(), (String)"pg-connector", Collections.singleton(errorMessage));
        return false;
    }

    private BigDecimal round(BigDecimal bigDecimal) {
        return bigDecimal.setScale(2, 4);
    }

    private BigDecimal noFraction(BigDecimal bigDecimal) {
        return bigDecimal.movePointRight(2);
    }

    private boolean equals(BigDecimal a, BigDecimal b) {
        BigDecimal noFractionA = this.noFraction(a);
        BigDecimal noFractionB = this.noFraction(b);
        return noFractionA.intValue() == noFractionB.intValue();
    }

    protected void createPaymentBillingTransaction() throws Exception {
        EntityContainer<BillingTransaction> billingTransactionCtr = this.createBillingTransaction();
        EntityStorage.get().save(billingTransactionCtr, true);
        this.payment.setBillingTransaction(billingTransactionCtr.toReference());
        BillingTransaction billingTransaction = (BillingTransaction)billingTransactionCtr.getEntity();
        Money sum = billingTransaction.getSum();
        Message info = MessageHelper.createMessage((String)"\u0421\u043e\u0437\u0434\u0430\u043d\u0430 \u0431\u0438\u043b\u043b\u0438\u043d\u0433-\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 {0} {1}", (Object[])new Object[]{sum.getValue(), sum.getCurrency()});
        this.messages.add(info);
        this.log.info(info.toString());
    }

    protected EntityContainer<BillingTransaction> createBillingTransaction() throws Exception {
        BillingTransaction billingTransaction = new BillingTransaction();
        billingTransaction.setCategory(BillingTransactionCategory.DEBIT);
        billingTransaction.setDate(new Date());
        billingTransaction.setStatus(BillingTransactionStatus.ACTIVE);
        billingTransaction.setType(BillingTransactionType.BILLING);
        billingTransaction.setAgency(this.payment.getPayee());
        billingTransaction.setClient(this.payment.getPayer());
        billingTransaction.setDescription(this.payment.getDescription());
        billingTransaction.setDetails((BaseTransactionDetails)this.payment.getDetails());
        billingTransaction.setPaymentType(this.payment.getPaymentType());
        billingTransaction.setAgent(this.salesContext.getAgent());
        Money money = new Money();
        String currency = DictHelper.getLocalCurrency();
        money.setCurrency(currency);
        money.setValue(this.payment.getAmount());
        billingTransaction.setSum(money);
        EntityContainer billingTransactionCtr = EntityContainer.create((BaseEntity)billingTransaction);
        VersionInfo versionInfo = billingTransactionCtr.getVersionInfo();
        versionInfo.setVersionNotes("create billing transaction");
        versionInfo.setDataSource("pgconnector");
        return billingTransactionCtr;
    }

    private void setPaymentStatus() {
        EntityContainer actualBookingFile;
        PaymentStatus newPaymentStatus = PaymentStatus.SUCCEEDED;
        if (Objects.nonNull(this.bookingFileCtr) && !PaymentHelper.isAllIssued(MidofficeHelper.getReservations((EntityContainer)(actualBookingFile = EntityStorage.get().resolve(this.bookingFileCtr.toReference())), PaymentHelper.getReservations((EntityContainer<BookingFile>)actualBookingFile, (Collection<String>)this.payment.getReservations())))) {
            newPaymentStatus = PaymentStatus.ERROR;
        }
        this.payment.setStatus(newPaymentStatus);
    }

    private void savePayment() {
        List<PgPaymentIndex> paymentIndexes = PaymentHelper.searchPayments((EntityReference<? extends BaseEntity>)this.payment.getEntity(), this.payment.getPaymentId());
        paymentIndexes.forEach(pgPaymentIndex -> EntityStorage.get().delete(pgPaymentIndex.getSource()));
        EntityContainer paymentCtr = EntityContainer.create((BaseEntity)this.payment);
        VersionInfo versionInfo = paymentCtr.getVersionInfo();
        versionInfo.setDataSource(this.getClass().getName());
        EntityStorage.get().save(paymentCtr, true);
    }

    public PaymentSucceedHandler setBookingFile(EntityContainer<BookingFile> bookingFileCtr) {
        this.bookingFileCtr = bookingFileCtr;
        return this;
    }

    public PaymentSucceedHandler setCreateFopsHandler(CreateFopsHandler createFopsHandler) {
        this.createFopsHandler = createFopsHandler;
        return this;
    }
}

