/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndexData;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.pg.PgMultiLogDocument;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;

public class PgMultiLogDocumentIndexHandler
implements IndexHandler<BaseFileDocument, BasicDocumentIndex> {
    public Class<? extends BaseIndexData<BaseFileDocument, BasicDocumentIndex>> getDataClass() {
        return BasicDocumentIndexData.class;
    }

    public Class<BasicDocumentIndex> getIndexClass() {
        return BasicDocumentIndex.class;
    }

    public Class<BaseFileDocument> getEntityType() {
        return BaseFileDocument.class;
    }

    public void create(EntityContainer<BaseFileDocument> etc, Collection<BaseIndexData<BaseFileDocument, BasicDocumentIndex>> indexes) {
        if (!PgMultiLogDocument.class.isAssignableFrom(((BaseFileDocument)etc.getEntity()).getClass())) {
            return;
        }
        BasicDocumentIndexData data = new BasicDocumentIndexData();
        PgMultiLogDocument entity = (PgMultiLogDocument)etc.getEntity();
        data.setContentType(entity.getContentType());
        data.setCreated(entity.getCreated());
        data.setName(entity.getName());
        data.setTitle(entity.getTitle());
        data.setCheckSum(entity.getCheckSum());
        int size = 0;
        for (Document item : entity.getDocuments()) {
            if (item.getContent() == null) continue;
            size += item.getContent().length;
        }
        data.setSize(size);
        data.setType(DocumentType.PG_TRACE);
        data.setOwner(entity.getOwner());
        data.setNavigationKey(entity.getNavigationKey());
        DataAggregator aggregator = new DataAggregator();
        aggregator.aggregate((Object)entity.getName());
        aggregator.aggregate(entity.getCreated());
        aggregator.aggregate((Enum)entity.getContentType());
        aggregator.aggregate((Object)entity.getDescription());
        aggregator.aggregate((Object)entity.getTitle());
        aggregator.aggregate((Object)etc.getUid());
        data.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<BaseFileDocument, BasicDocumentIndex>)data);
    }
}

