/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.pg.helper.AllowedPaymentTypesHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class PgPaymentBuilder<E extends PgPaymentBuilder<E>> {
    protected EntityContainer<BookingFile> bookingFileCtr;
    protected Collection<Reservation> reservations;
    protected PaymentType paymentType;
    protected Card card;
    protected BigDecimal amount;
    protected BigDecimal fee;
    protected final List<NamedValue> customParameters = new ArrayList<NamedValue>();

    public E setBookingFileCtr(EntityContainer<BookingFile> bookingFileCtr) {
        this.bookingFileCtr = bookingFileCtr;
        return (E)this;
    }

    public E setReservations(Collection<Reservation> reservations) {
        this.reservations = reservations;
        return (E)this;
    }

    public E setPaymentType(PaymentType paymentType) {
        this.paymentType = paymentType;
        return (E)this;
    }

    public E setCard(Card card) {
        this.card = card;
        return (E)this;
    }

    public E setAmount(BigDecimal amount) {
        this.amount = amount;
        return (E)this;
    }

    public E setFee(BigDecimal fee) {
        this.fee = fee;
        return (E)this;
    }

    public E addCustomParameter(NamedValue customParameter) {
        this.customParameters.add(customParameter);
        return (E)this;
    }

    public Payment build() throws NullPointerException {
        Objects.requireNonNull(this.bookingFileCtr);
        Payment payment = new Payment();
        BookingFile bookingFile = (BookingFile)this.bookingFileCtr.getEntity();
        payment.setPaymentId(UUID.randomUUID().toString());
        payment.setEntity(this.bookingFileCtr.toReference());
        if (this.reservations != null) {
            this.reservations.forEach(r -> payment.getReservations().add(r.getUid()));
        }
        payment.setPayee(bookingFile.getAgency());
        payment.setPayer(bookingFile.getCustomerProfile());
        Customer customer = bookingFile.getCustomer();
        if (Objects.nonNull(customer)) {
            payment.getCustomerInfo().setPreferredLocale(customer.getPreferredLocale());
        }
        if (this.reservations != null) {
            payment.setDescription(String.format("\u041e\u043f\u043b\u0430\u0442\u0430 \u0431\u0440\u043e\u043d\u0438: %s", this.reservations.stream().map(CommonReservationGdsNameInfoHelper::getDisplayedRecordLocator).collect(Collectors.joining(", "))));
        } else {
            Reservation firstReservation = BookingHelper.getBaseProductReservation((BookingFile)bookingFile, (boolean)true);
            payment.getReservations().add(firstReservation.getUid());
            payment.setDescription(String.format("\u041e\u043f\u043b\u0430\u0442\u0430 \u0437\u0430\u043a\u0430\u0437\u0430 %s", CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)firstReservation)));
        }
        if (Objects.nonNull(this.paymentType)) {
            Set<PaymentType> allowedPaymentTypes = AllowedPaymentTypesHandler.get().getAllowedPaymentTypes(this.bookingFileCtr);
            if (!allowedPaymentTypes.contains(this.paymentType)) {
                throw Xeption.forEndUser((String)"PAYMENT_PG_BUILDER_INCORRECT_PAYMENT_TYPE", (Object[])new Object[]{TextUtil.buildFullNumber((CompositeNumber)bookingFile), this.paymentType});
            }
            payment.setPaymentType(this.paymentType);
        }
        payment.setAmount(this.amount);
        payment.setFee(this.fee);
        payment.getCustomParameters().addAll(this.customParameters);
        return payment;
    }
}

