/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;

public class PgSysLogItem {
    private final String tag;
    private final String message;
    private MessageType messageType = MessageType.MESSAGE;
    private final StringBuilder details = new StringBuilder();

    public String getTag() {
        return this.tag;
    }

    public PgSysLogItem(String tag, String message) {
        this.tag = tag;
        this.message = message;
        this.addMessage("Started process " + Environment.getApplicationId());
    }

    public void addMessage(String message) {
        if (this.details.length() > 0) {
            this.details.append("\r");
        }
        this.details.append(message);
    }

    public void addMessage(String format, Object ... args) {
        if (this.details.length() > 0) {
            this.details.append("\r");
        }
        this.details.append(String.format(format, args));
    }

    public void addError(String format, Object ... args) {
        this.addMessage(format, args);
        this.setMessageType(MessageType.ERROR);
    }

    public void addWarning(String message) {
        this.addMessage(message);
        this.setMessageType(MessageType.WARNING);
    }

    private void setMessageType(MessageType type) {
        if (this.messageType.ordinal() < type.ordinal()) {
            this.messageType = type;
        }
    }

    public Message toMessage() {
        Message log = SystemHelper.createMessage((MessageType)this.messageType, (String)this.message, (Object[])new Object[0]);
        log.setDetails(this.details.toString());
        log.setType(this.messageType);
        return log;
    }
}

