/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.pg.SplitPaymentRegistry;
import com.gridnine.xtrip.common.model.pg.SplitPaymentSupport;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.PGConnectorRegistry;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class SplitPaymentRegistryImpl
implements SplitPaymentRegistry {
    public boolean isSplitPayment(PaymentType paymentType) {
        for (PGConnector connector : ((PGConnectorRegistry)Environment.getPublished(PGConnectorRegistry.class)).getAll()) {
            SplitPaymentSupport conn;
            if (!(connector instanceof SplitPaymentSupport) || (conn = (SplitPaymentSupport)connector).getSplitMainPaymentType() != paymentType) continue;
            return true;
        }
        return false;
    }

    public Set<SplitPaymentSupport> getSplitPaymentSupportedConnectors() {
        HashSet<SplitPaymentSupport> connectors = new HashSet<SplitPaymentSupport>();
        for (PGConnector connector : ((PGConnectorRegistry)Environment.getPublished(PGConnectorRegistry.class)).getAll()) {
            if (!(connector instanceof SplitPaymentSupport)) continue;
            connectors.add((SplitPaymentSupport)connector);
        }
        return connectors;
    }

    public Set<PaymentType> getSplitPaymentTypes() {
        Set<SplitPaymentSupport> connectors = this.getSplitPaymentSupportedConnectors();
        HashSet<PaymentType> paymentTypes = new HashSet<PaymentType>();
        for (SplitPaymentSupport splitPaymentSupportable : connectors) {
            paymentTypes.add(splitPaymentSupportable.getSplitMainPaymentType());
        }
        return paymentTypes;
    }

    public Set<PaymentType> getAgencyPaymentTypes() {
        Set<SplitPaymentSupport> connectors = this.getSplitPaymentSupportedConnectors();
        HashSet<PaymentType> paymentTypes = new HashSet<PaymentType>();
        for (SplitPaymentSupport splitPaymentSupportable : connectors) {
            paymentTypes.add(splitPaymentSupportable.getSplitAgencyPaymentType());
        }
        return paymentTypes;
    }

    public Set<PaymentType> getSupplierPaymentTypes() {
        Set<SplitPaymentSupport> connectors = this.getSplitPaymentSupportedConnectors();
        HashSet<PaymentType> paymentTypes = new HashSet<PaymentType>();
        for (SplitPaymentSupport splitPaymentSupportable : connectors) {
            paymentTypes.add(splitPaymentSupportable.getSplitSupplierPaymentType());
        }
        return paymentTypes;
    }

    public SplitPaymentSupport isSplitOrSupplierPaymentType(PaymentType paymentType) {
        for (SplitPaymentSupport splitPmtSupport : this.getSplitPaymentSupportedConnectors()) {
            if (splitPmtSupport.getSplitMainPaymentType() != paymentType && splitPmtSupport.getSplitSupplierPaymentType() != paymentType) continue;
            return splitPmtSupport;
        }
        return null;
    }

    public Optional<PaymentType> getAgencyPaymentType(PaymentType splitMainPaymentType) {
        return this.getSplitPaymentSupportedConnectors().stream().filter(connector -> connector.getSplitMainPaymentType() == splitMainPaymentType).map(connector -> connector.getSplitAgencyPaymentType()).findAny();
    }

    public Optional<PaymentType> getSupplierPaymentType(PaymentType splitMainPaymentType) {
        return this.getSplitPaymentSupportedConnectors().stream().filter(connector -> connector.getSplitMainPaymentType() == splitMainPaymentType).map(connector -> connector.getSplitSupplierPaymentType()).findAny();
    }
}

