/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.card;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.w3c.dom.Element;

public final class CardPaymentResult
implements XSerializable {
    private final boolean success;
    private final String errorMessage;
    private final EntityContainer<Document> slipDocument;
    private final Map<String, Object> ctx;

    private CardPaymentResult(Builder builder) throws NullPointerException {
        Objects.requireNonNull(builder);
        this.success = builder.success;
        this.errorMessage = builder.errorMessage;
        this.slipDocument = builder.slipDocument;
        this.ctx = builder.ctx;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public EntityContainer<Document> getSlipDocument() {
        return this.slipDocument;
    }

    public Map<String, Object> getCtx() {
        return this.ctx;
    }

    public void toXML(Element elm) throws Exception {
        XHelper.writeBoolean((Element)elm, (String)"success", (boolean)this.success);
        XHelper.writeString((Element)elm, (String)"errorMessage", (String)this.errorMessage);
        XHelper.writeMap((Element)elm, (String)"ctx", this.ctx);
    }

    public void fromXML(Element elm) throws Exception {
        throw new RuntimeException("not supported");
    }

    public static class Builder {
        private boolean success;
        private String errorMessage;
        private EntityContainer<Document> slipDocument;
        private final Map<String, Object> ctx = new HashMap<String, Object>();

        public Builder setSuccess(boolean success) {
            this.success = success;
            return this;
        }

        public Builder setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public CardPaymentResult build() {
            return new CardPaymentResult(this);
        }

        public Builder setSlipDocument(EntityContainer<Document> documentCtr) {
            this.slipDocument = documentCtr;
            return this;
        }

        public Builder putObject(Enum<?> key, Object value) {
            this.ctx.put(key.name(), value);
            return this;
        }
    }
}

