/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.card;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FopType;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.helpers.CommonPgFopInfoUtil;
import com.gridnine.xtrip.common.pg.model.CardPaymentStrategy;
import com.gridnine.xtrip.common.pg.model.FopInfo;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.rules.elements.DebugInfo;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.rules.BookingCommissionsCalculator;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.PGConnectorRegistry;
import com.gridnine.xtrip.server.pg.card.CardPayment;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CardPaymentUtils {
    public static final String DESCRIPTION_KEY = CardPaymentUtils.class.getName() + ".product-description";
    public static final String STRATEGY_KEY = CardPaymentUtils.class.getName() + ".strategy";

    private CardPaymentUtils() throws RuntimeException {
        throw new RuntimeException("don't do this");
    }

    public static void applyRules(EntityContainer<BookingFile> bookingFileCtr) {
        BookingCommissionsCalculator bookingCommissionsCalculator = (BookingCommissionsCalculator)Environment.getPublished(BookingCommissionsCalculator.class);
        ArrayList messages = new ArrayList();
        HashMap params = new HashMap();
        DebugInfo debugInfo = new DebugInfo();
        try {
            bookingCommissionsCalculator.applyRules(bookingFileCtr, true, true, messages, params, debugInfo);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Predicate<? super BaseProduct> checked() {
        return baseProduct -> CardPaymentUtils.productHandler(baseProduct).isChecked(baseProduct);
    }

    public static Consumer<? super BaseProduct> rulesApplied(boolean value) {
        return baseProduct -> CardPaymentUtils.productHandler(baseProduct).setContractRulesApplied(baseProduct, value);
    }

    public static <P extends BaseProduct> ProductHandler<? super P> productHandler(P product) {
        return HandlersRegistry.get().findProductHandler(product.getClass());
    }

    public static void updateProductAndFops(BookingFile bookingFile, Predicate<? super BaseProduct> productFilter, Consumer<? super BaseProduct> productUpdater, BiPredicate<? super BaseProduct, ? super GeneralProductFop> fopFilter, BiConsumer<? super BaseProduct, ? super GeneralProductFop> fopUpdater) {
        Objects.requireNonNull(bookingFile);
        Objects.requireNonNull(productFilter);
        Objects.requireNonNull(productUpdater);
        Objects.requireNonNull(fopUpdater);
        BookingStreamHelper.baseProductStreamSafe((BookingFile)bookingFile).filter(productFilter).peek(productUpdater).forEach(baseProduct -> CardPaymentUtils.updateProductFop(baseProduct, fopFilter, fopUpdater));
    }

    private static void updateProductFop(BaseProduct baseProduct, BiPredicate<? super BaseProduct, ? super GeneralProductFop> fopFilter, BiConsumer<? super BaseProduct, ? super GeneralProductFop> fopUpdater) {
        List generalProductContractRelationDataList = GeneralProductHelper.copyContractRelations((BaseProduct)baseProduct);
        CardPaymentUtils.clientFopStream(generalProductContractRelationDataList).filter(generalProductFop -> fopFilter.test((BaseProduct)baseProduct, (GeneralProductFop)generalProductFop)).forEach(generalProductFop -> fopUpdater.accept((BaseProduct)baseProduct, (GeneralProductFop)generalProductFop));
        CardPaymentUtils.productHandler(baseProduct).updateContractRelations(baseProduct, generalProductContractRelationDataList);
    }

    public static Map<BaseProduct, List<FopInfo>> unpaidFops(BookingFile bookingFile, PaymentType paymentType, Map<BaseProduct, List<FopInfo>> previousFops) {
        HashMap<BaseProduct, List<FopInfo>> result = new HashMap<BaseProduct, List<FopInfo>>();
        List products = BookingStreamHelper.baseProductStreamSafe((BookingFile)bookingFile).collect(Collectors.toList());
        for (BaseProduct product : products) {
            ProductHandler<BaseProduct> productHandler = CardPaymentUtils.productHandler(product);
            List contractRelations = productHandler.getUnmodifiableContractRelations(product);
            List clientFops = contractRelations.stream().filter(generalProductContractRelationData -> ContractType.CLIENT == GeneralProductHelper.getContractType((EntityReference)generalProductContractRelationData.getDescription())).map(GeneralProductContractRelationData::getFops).flatMap(Collection::stream).collect(Collectors.toList());
            ArrayList<FopInfo> fopInfos = new ArrayList<FopInfo>(clientFops.size());
            for (GeneralProductFop fop : clientFops) {
                CardPaymentUtils.modify(product, fop);
                if (CardPaymentUtils.isPaid(fop) || paymentType != fop.getType() || fop.getEquivalentAmount().signum() <= 0) continue;
                fopInfos.add(CommonPgFopInfoUtil.toInfo((BaseProduct)product, (GeneralProductFop)fop));
            }
            if (fopInfos.isEmpty()) continue;
            if (!productHandler.isChecked(product)) {
                CardPaymentUtils.correction(fopInfos, previousFops.get(product));
                CardPaymentUtils.binding(fopInfos);
            }
            result.put(product, fopInfos);
        }
        return result;
    }

    public static boolean isPaid(GeneralProductFop fop) {
        return fop.getOperationDate() != null;
    }

    private static Stream<GeneralProductFop> clientFopStream(List<GeneralProductContractRelationData> generalProductContractRelationDataList) {
        return generalProductContractRelationDataList.stream().filter(generalProductContractRelationData -> ContractType.CLIENT == GeneralProductHelper.getContractType((EntityReference)generalProductContractRelationData.getDescription())).map(GeneralProductContractRelationData::getFops).flatMap(Collection::stream);
    }

    public static void modify(BaseProduct baseProduct, GeneralProductFop generalProductFop) {
        ProductStatus productStatus = CardPaymentUtils.productHandler(baseProduct).getStatus(baseProduct);
        if (ProductStatus.REFUND != productStatus) {
            return;
        }
        BigDecimal equivalentAmount = generalProductFop.getEquivalentAmount();
        generalProductFop.setEquivalentAmount(equivalentAmount.negate());
    }

    public static void correction(List<FopInfo> currentFops, List<FopInfo> previousFops) {
        BigDecimal previousAmount;
        if (Objects.isNull(previousFops)) {
            return;
        }
        Map<FopType, FopInfo> currentByType = CardPaymentUtils.byType(currentFops);
        Map<FopType, FopInfo> previousByType = CardPaymentUtils.byType(previousFops);
        FopInfo currentPaymentFop = currentByType.get(FopType.PAYMENT);
        FopInfo previousPaymentFop = previousByType.get(FopType.PAYMENT);
        if (Objects.isNull(currentPaymentFop) || Objects.isNull(previousPaymentFop)) {
            return;
        }
        BigDecimal currentAmount = currentPaymentFop.getAmount();
        if (currentAmount.compareTo(previousAmount = previousPaymentFop.getAmount()) > 0) {
            currentPaymentFop.setAmount(currentAmount.subtract(previousAmount));
        }
    }

    private static void binding(List<FopInfo> fops) {
        Objects.requireNonNull(fops);
        Map<FopType, FopInfo> byType = CardPaymentUtils.byType(fops);
        FopInfo productFop = byType.get(FopType.PRODUCT);
        if (Objects.nonNull(productFop)) {
            FopInfo paymentFop = byType.get(FopType.PAYMENT);
            productFop.setRelated(paymentFop);
        }
    }

    private static Map<FopType, FopInfo> byType(List<FopInfo> fops) {
        return fops.stream().collect(Collectors.toMap(FopInfo::getFopType, Function.identity(), (o, o2) -> o2, HashMap::new));
    }

    public static CardPaymentStrategy strategy(Payment payment) {
        Objects.requireNonNull(payment);
        String strategyName = NamedValueHelper.getValueForName((String)STRATEGY_KEY, (Collection)payment.getCustomParameters());
        return Objects.isNull(strategyName) ? CardPaymentStrategy.STANDARD : CardPaymentStrategy.valueOf((String)strategyName);
    }

    public static CardPayment cardPayment(PaymentType paymentType) {
        if (Objects.isNull(paymentType)) {
            return null;
        }
        PGConnector pgConnector = PGConnectorRegistry.get().get(paymentType);
        if (!CardPayment.class.isInstance(pgConnector)) {
            return null;
        }
        CardPayment cardPayment = (CardPayment)((Object)pgConnector);
        if (!cardPayment.supportedPaymentTypes().contains(paymentType)) {
            return null;
        }
        return cardPayment;
    }

    public static MiscUtil.Pair<Person, Xeption> traveller(BookingFile bookingFile, CardPayment cardPayment) {
        Objects.requireNonNull(bookingFile);
        Objects.requireNonNull(cardPayment);
        MiscUtil.Pair personXeptionPair = new MiscUtil.Pair();
        List travellers = bookingFile.getTravellers();
        if (CollectionUtil.isEmpty((Collection)travellers)) {
            personXeptionPair.setSecond((Object)Xeption.forDeveloper((String)"\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0432\u0443\u044e\u0442", (Object[])new Object[0]));
        } else if (travellers.size() > 1) {
            personXeptionPair.setSecond((Object)Xeption.forDeveloper((String)"\u0411\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e \u043f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a\u0430 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0430\u043d\u043e", (Object[])new Object[0]));
        } else {
            Optional<Object> traveller = Optional.ofNullable(CollectionUtil.head((Iterable)travellers));
            Optional<String> validateTraveller = traveller.map(cardPayment::validateTraveller);
            if (validateTraveller.isPresent()) {
                personXeptionPair.setSecond((Object)Xeption.forDeveloper((String)validateTraveller.get(), (Object[])new Object[0]));
            } else {
                Person person = traveller.map(Traveller::getPassenger).map(EntityStorageHelper::resolve).map(EntityStorageHelper::entity).orElse(null);
                if (Objects.isNull(person)) {
                    personXeptionPair.setSecond((Object)Xeption.forDeveloper((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u043f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a\u0430", (Object[])new Object[0]));
                } else {
                    personXeptionPair.setFirst((Object)person);
                }
            }
        }
        return personXeptionPair;
    }
}

