/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.common;

import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeCalculationBasis;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeType;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.commission.ReturnCase;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.booking.commission.RouteType;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.CommissionCategoryReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.SalesPointType;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.IBusPgContextKeys;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.pg.rules.PGRulesEnvironment;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import com.gridnine.xtrip.server.pg.PgConfigurationCompaundKeyProvider;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class PgTestBase
extends ModelTestBase {
    protected EntityReference<Organization> client = new EntityReference("retail_profile_container", Organization.class, "Retail profile");
    protected EntityReference<Organization> blankOwner = new EntityReference("TCH_container", Organization.class, "Blank Owner");
    protected EntityReference<Organization> agency = new EntityReference("test_agency_container_uid", Organization.class, "Agency");
    protected EntityReference<Organization> subagency = new EntityReference("subagency_container", Organization.class, "Subagency");
    protected EntityReference<Person> agent = new EntityReference("test_director_container_uid", Person.class, "Agent");
    protected EntityReference<Person> customer = new EntityReference("test_accountant_container_uid", Person.class, "Customer");
    protected EntityReference<SalesPoint> salesPoint = new EntityReference("test_sales_point_uid", SalesPoint.class, "Sales Point");
    protected EntityReference<Contract> contract = new EntityReference("test_contract", Contract.class, "Client Contract");
    protected EntityReference<FeeProperties> sellFee = new EntityReference("sell_fee", FeeProperties.class, "Sell Fee");
    protected EntityReference<PaymentFeeProperties> paymentFee = new EntityReference("payment_fee", PaymentFeeProperties.class, "Payment Fee");
    protected EntityReference<BookingFile> booking = new EntityReference("booking", BookingFile.class, "Booking");
    protected PaymentType paymentType = PaymentType.CASH;
    protected PgName pgName = null;
    protected double tariffFare = 1000.0;
    protected double taxAmount = 500.0;

    public void setUp() throws Exception {
        PgTestBase.setSysProp((String)"midoffice.ibus.pg.reprice.testmode", (String)"true");
        PgTestBase.setSysProp((String)"midoffice.ibus.pg.issue.testmode", (String)"true");
        super.setUp();
        this.createSalesPoint();
        this.createContract();
        this.createBookingFile();
    }

    protected void updateMessageContext(Map<String, Object> ctx) {
        ctx.put(IBusPgContextKeys.BOOKING_UID.name(), this.booking.getUid());
        ctx.put(IBusPgContextKeys.PAYMENT_TYPE.name(), this.paymentType);
        ctx.put(IBusPgContextKeys.BOOKING_PRICE.name(), BookingHelper.getTotalPrice((BookingFile)((BookingFile)EntityStorage.get().resolve(this.booking).getEntity()), (ContractType)ContractType.CLIENT));
        ctx.put(IBusPgContextKeys.USER_IP.name(), "127.0.0.1");
        SalesContext salesContext = new SalesContext();
        salesContext.setAgency(this.agency);
        salesContext.setAgent(this.agent);
        salesContext.setSalesPoint(this.salesPoint);
        salesContext.setSubagency(this.subagency);
        salesContext.setCustomer(this.customer);
        ctx.put(IBusPgContextKeys.SALES_CONTEXT.name(), salesContext);
        if (this.pgName != null) {
            ctx.put(IBusPgContextKeys.PG_NAME.name(), this.pgName);
            ctx.put(IBusPgContextKeys.PG_CONFIGURATION.name(), EntityStorage.get().find(BasicSystemSettingsIndex.class, BasicSystemSettingsIndex.Property.compoundKey.name(), (Object)PgConfigurationCompaundKeyProvider.getCompaundKey(this.pgName)).getEntity());
        }
    }

    private void createContract() {
        EntityContainer sellFeeCtr = new EntityContainer(FeeProperties.class, this.sellFee.getUid());
        FeeProperties prop = (FeeProperties)sellFeeCtr.getEntity();
        prop.setCategory((DictionaryReference)new CommissionCategoryReference("fee"));
        prop.setRoundingMode(RoundingMode.MATH);
        prop.setRoundingValue(RoundingValue.V_0_0_1);
        prop.setOperation(Operation.SELL);
        prop.getProductTypes().addAll(Arrays.asList(ProductType.values()));
        prop.getReturnCases().add(ReturnCase.EXCHANGE);
        prop.getReturnCases().add(ReturnCase.FORCED_EXCHANGE);
        prop.getReturnCases().add(ReturnCase.REFUND);
        prop.getReturnCases().add(ReturnCase.FORCED_REFUND);
        prop.getRouteTypes().add(RouteType.ONE_WAY);
        prop.getRouteTypes().add(RouteType.ROUND_TRIP);
        prop.setDisplayName("sell fee");
        EntityStorage.get().save(sellFeeCtr, true);
        EntityContainer paymentFeeCtr = new EntityContainer(PaymentFeeProperties.class, this.paymentFee.getUid());
        prop = (PaymentFeeProperties)paymentFeeCtr.getEntity();
        prop.setPaymentType(this.paymentType);
        prop.setRoundingMode(RoundingMode.MATH);
        prop.setRoundingValue(RoundingValue.V_0_0_1);
        prop.setBasis(PaymentFeeCalculationBasis.PRICE);
        prop.setType(PaymentFeeType.STANDARD);
        prop.setDisplayName("payment fee");
        EntityStorage.get().save(paymentFeeCtr, true);
        EntityContainer cc = new EntityContainer(Contract.class, this.contract.getUid());
        Contract contractEtt = (Contract)cc.getEntity();
        ContractCustomerInfo info = new ContractCustomerInfo();
        contractEtt.getCustomers().add(info);
        contractEtt.setContractType(ContractType.CLIENT);
        contractEtt.setSupplier(this.subagency);
        info.setCustomer(this.client);
        info.setNumber("01");
        RuleSet rules = new RuleSet();
        RuleSettings rs = new RuleSettings();
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        rs.setName("Fee");
        RuleResult res = new RuleResult();
        RuleResultValue value = new RuleResultValue();
        value.setCurrencyCode("RUB");
        value.setValue(100.0);
        value.setTarget(this.sellFee);
        res.setValue((Object)value);
        res.setAction((RuleAction)Actions.SIMPLE_FEE);
        rs.getResults().add(res);
        rules.getRules().add(rs);
        rs = new RuleSettings();
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        rs.setName("Payment Fee");
        res = new RuleResult();
        value = new RuleResultValue();
        value.setCurrencyCode("%");
        value.setValue(3.0);
        value.setTarget(this.paymentFee);
        res.setValue((Object)value);
        res.setAction((RuleAction)Actions.PAYMENT_FEE);
        rs.getResults().add(res);
        rules.getRules().add(rs);
        contractEtt.setRuleSet(rules);
        EntityStorage.get().save(cc, true);
    }

    private void createSalesPoint() {
        EntityContainer salesPointContainer = new EntityContainer(SalesPoint.class, this.salesPoint.getUid());
        SalesPoint entity = (SalesPoint)salesPointContainer.getEntity();
        entity.setAgency(this.agency);
        entity.setCode("001SP");
        entity.setFullName("Test Sales Point");
        entity.setShortName("Test Sales Point");
        entity.setType(SalesPointType.SALES_OFFICE);
        RuleSet ruleSet = new RuleSet();
        entity.setRuleSet(ruleSet);
        RuleSettings rs = new RuleSettings();
        rs.setTarget((RuleTarget)com.gridnine.xtrip.common.pg.rules.Targets.PG_PARAMETERS);
        ruleSet.getRules().add(rs);
        rs.setName("pg account");
        RuleResult ruleResult = new RuleResult();
        rs.getResults().add(ruleResult);
        ruleResult.setAction((RuleAction)com.gridnine.xtrip.common.pg.rules.Actions.PG_ACCOUNT);
        ruleResult.setValue((Object)"testLogin");
        ruleResult = new RuleResult();
        rs.getResults().add(ruleResult);
        ruleResult.setAction((RuleAction)com.gridnine.xtrip.common.pg.rules.Actions.PG_PASSWORD);
        ruleResult.setValue((Object)"testPassword");
        EntityStorage.get().save(salesPointContainer, true);
    }

    private void createBookingFile() throws Exception {
        EntityContainer bfc = new EntityContainer(BookingFile.class, this.booking.getUid());
        BookingFile result = (BookingFile)bfc.getEntity();
        result.setAgency(this.agency);
        result.setCustomerProfile(this.client);
        Reservation reservation = new Reservation();
        reservation.setBookingFile(result);
        result.getReservations().add(reservation);
        reservation.setSalesPoint(this.salesPoint);
        this.setRecordLocator(reservation, GdsName.SABRE, "PNR");
        reservation.setSubagency(this.subagency);
        Traveller traveller = new Traveller();
        traveller.setName("Test Person");
        result.getTravellers().add(traveller);
        result.setAgency(this.agency);
        Product product = new Product();
        product.setReservation(reservation);
        reservation.getProducts().add(product);
        product.setTraveller(traveller);
        product.setProductCategory(ProductCategory.AIR);
        product.setBlankOwnerRef(this.blankOwner);
        product.setBlankOwnerNumber("99A");
        product.setStatus(ProductStatus.BOOKING);
        product.setCarrier((DictionaryReference)new AirlineReference("SU"));
        product.setCarrierNumber("555");
        product.setBlankType((DictionaryReference)new BlankTypeReference("99A 661"));
        AirProductHelper.setAgency((Product)product, this.agency);
        AirProductHelper.setSupplier((Product)product, (EntityReference)product.getBlankOwnerRef());
        Segment segment = new Segment();
        segment.setStartDate(Calendar.getInstance().getTime());
        segment.setAirline((DictionaryReference)new AirlineReference("SU"));
        segment.setDepartureLocation((DictionaryReference)new GeoLocationReference("MOW"));
        segment.setArriveLocation((DictionaryReference)new GeoLocationReference("PAR"));
        segment.setFareBasis("farebasis");
        SegmentTariff sppPsgr = new SegmentTariff();
        sppPsgr.getSegments().add(segment);
        product.getSegmentTariffs().add(sppPsgr);
        AirProductHelper.setSegmentEquivalentFare((Product)product, (SegmentTariff)sppPsgr, (BigDecimal)BigDecimal.valueOf(this.tariffFare));
        AirProductHelper.setSegmentBaseFare((Product)product, (SegmentTariff)sppPsgr, (Money)SystemHelper.getMoney((double)this.tariffFare, (String)"RUB"));
        Tax tax = new Tax();
        tax.setCode("ZZ");
        tax.setEquivalentAmount(BigDecimal.valueOf(this.taxAmount));
        tax.setSegmentTariff(sppPsgr);
        product.getTaxes().add(tax);
        ProductFop fop = new ProductFop();
        AirProductHelper.getVendorContractRelation((Product)product).getFops().add(fop);
        fop.setType(PaymentType.CASH);
        fop.setAmount(SystemHelper.getMoney((double)(this.tariffFare + this.taxAmount), (String)"RUB"));
        product.setIssueDate(new Date());
        EntityStorage.get().save(bfc, true);
    }

    protected List<URL> collectIntegrationBusDescriptions() {
        ArrayList<URL> lst = new ArrayList<URL>(super.collectIntegrationBusDescriptions());
        lst.add(this.getResource("com/gridnine/xtrip/server/model/ibus/http"));
        lst.add(this.getResource("com/gridnine/xtrip/server/ibus/rest"));
        lst.add(this.getResource("com/gridnine/bof/midoffice/ibus"));
        lst.add(this.getResource("com/gridnine/xtrip/server/pg/ibus/common"));
        lst.add(this.getResource("com/gridnine/xtrip/server/pg/common"));
        lst.add(this.getResource("com/gridnine/xtrip/server/pg/test/ibus"));
        return lst;
    }

    private URL getResource(String name) {
        URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource(name);
        if (resource == null) {
            throw Xeption.forDeveloper((String)("resource not found " + name), (Object[])new Object[0]);
        }
        return resource;
    }

    protected boolean isUseNoSchemeTestStorage() {
        return false;
    }

    protected void configureRulesEnvironment(RulesEnvironment re) {
        super.configureRulesEnvironment(re);
        new PGRulesEnvironment().environmentInitialized(re);
    }

    protected void configureMetaregistry(MetaRegistry metaRegistry) throws Exception {
        super.configureMetaregistry(metaRegistry);
        metaRegistry.register(this.getResource("com/gridnine/xtrip/common/pg/model-pg.xml"));
        metaRegistry.register(this.getResource("com/gridnine/xtrip/common/pg/model-basic-pg.xml"));
    }
}

