/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.handlers;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.server.pg.handlers.BookingFileUpdateFopTypeHandler;
import com.gridnine.xtrip.server.pg.handlers.CustomProductFopsHandler;
import com.gridnine.xtrip.server.pg.handlers.GdsSplitPaymentSupportHandler;
import com.gridnine.xtrip.server.pg.handlers.PaymentFeeHandler;
import com.gridnine.xtrip.server.pg.handlers.PaymentStatusHandler;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgHandlersRegistry
implements Disposable {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final Set<GdsName> splitPaymentGdsSupporting = new HashSet<GdsName>();
    private PaymentStatusHandler paymentStatusHandler;
    private PaymentFeeHandler paymentFeeHandler;
    private BookingFileUpdateFopTypeHandler bookingFileUpdateFopTypeHandler;
    private CustomProductFopsHandler customProductFopHandler;

    public PgHandlersRegistry() {
        this.splitPaymentGdsSupporting.add(GdsName.SABRE);
    }

    public static Optional<BookingFileUpdateFopTypeHandler> getUpdateFopTypeHandler() {
        return Optional.ofNullable(((PgHandlersRegistry)Environment.getPublished(PgHandlersRegistry.class)).getBookingFileUpdateFopTypeHandler());
    }

    public static Optional<PaymentStatusHandler> getPaymentStatusHandler() {
        return Optional.ofNullable(((PgHandlersRegistry)Environment.getPublished(PgHandlersRegistry.class)).paymentStatusHandler);
    }

    public Set<GdsName> getSplitPaymentGdsSupporting() {
        return this.splitPaymentGdsSupporting;
    }

    public CustomProductFopsHandler getCustomProductFopHandler() {
        return this.customProductFopHandler;
    }

    public BookingFileUpdateFopTypeHandler getBookingFileUpdateFopTypeHandler() {
        return this.bookingFileUpdateFopTypeHandler;
    }

    public void dispose() {
        this.paymentStatusHandler = null;
        this.paymentFeeHandler = null;
        this.bookingFileUpdateFopTypeHandler = null;
        this.log.debug("disposed");
    }

    public void register(CustomProductFopsHandler handler) {
        if (this.customProductFopHandler != null) {
            this.log.warn("customProductFopHandler already registered");
            return;
        }
        this.customProductFopHandler = handler;
        this.log.info("registered customProductFopHandler");
    }

    public void register(BookingFileUpdateFopTypeHandler fopTypeHandler) {
        if (this.bookingFileUpdateFopTypeHandler != null) {
            this.log.warn("updateFopHandler already registered");
            return;
        }
        this.bookingFileUpdateFopTypeHandler = fopTypeHandler;
        this.log.info("registered updateFopHandler");
    }

    public void register(GdsSplitPaymentSupportHandler gdsSupport) {
        GdsName addGds = gdsSupport.addGds();
        this.splitPaymentGdsSupporting.add(addGds);
        this.log.info("registred reservation system " + addGds + " for split payments");
    }

    public void register(PaymentStatusHandler handler) {
        if (this.paymentStatusHandler != null) {
            this.log.warn("payment status handler already registered");
            return;
        }
        this.paymentStatusHandler = handler;
        this.log.info("registered payment status handler");
    }

    public PaymentFeeHandler getPaymentFeeHandler() {
        return this.paymentFeeHandler;
    }
}

