/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.ibus.card;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.IBusPgContextKeys;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.pg.PgPaymentBuilder;
import com.gridnine.xtrip.server.pg.card.CardPayment;
import com.gridnine.xtrip.server.pg.card.CardPaymentParameters;
import com.gridnine.xtrip.server.pg.card.CardPaymentUtils;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import java.util.Objects;

public class CardPaymentCreatePaymentProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Fop fop = (Fop)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.FOP);
        EntityContainer bookingFileCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Card travellerCard = (Card)ctx.getMandatoryObject((Enum)IBusPgContextKeys.SELECTED_PAYMENT_CARD);
        String descriptionStr = (String)ctx.getObject((Enum)IBusPgConnectorContextKeys.PRODUCT_DESCRIPTION_COMMENT);
        PaymentType paymentType = fop.getType();
        CardPayment cardPayment = CardPaymentUtils.cardPayment(paymentType);
        if (Objects.isNull(cardPayment)) {
            throw Xeption.forDeveloper((String)"cardPayment is null!", (Object[])new Object[0]);
        }
        Payment payment = ((PgPaymentBuilder)((PgPaymentBuilder)((PgPaymentBuilder)((PgPaymentBuilder)cardPayment.newPaymentBuilder().setBookingFileCtr((EntityContainer<BookingFile>)bookingFileCtr)).setPaymentType(paymentType)).setCard(travellerCard)).addCustomParameter(NamedValueHelper.namedValue((String)CardPaymentUtils.DESCRIPTION_KEY, (String)descriptionStr))).build();
        CardPaymentParameters cardPaymentParameters = cardPayment.newCardPaymentParametersBuilder().setSalesContext(salesContext).setBookingFileCtr((EntityContainer<BookingFile>)bookingFileCtr).setPayment(payment).setCard(travellerCard).setFop(fop).build();
        ctx.putObject((Enum)IBusPgConnectorContextKeys.PAYMENT, (Object)payment);
        ctx.putObject((Enum)IBusPgConnectorContextKeys.CARD_PAYMENT, (Object)cardPayment);
        ctx.putObject((Enum)IBusPgConnectorContextKeys.CARD_PAYMENT_PARAMETERS, (Object)cardPaymentParameters);
    }
}

