/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.ibus.card;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.server.ibus.IbusHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.pg.card.CardPayment;
import com.gridnine.xtrip.server.pg.card.CardPaymentParameters;
import com.gridnine.xtrip.server.pg.card.CardPaymentResult;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class CardPaymentProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        CardPayment cardPayment = (CardPayment)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.CARD_PAYMENT);
        CardPaymentParameters cardPaymentParameters = (CardPaymentParameters)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.CARD_PAYMENT_PARAMETERS);
        Map slipCtrs = (Map)IbusHelper.getObjectN((MessageContext)ctx, (Enum)IBusPgConnectorContextKeys.CARD_PAYMENT_SLIPS, HashMap::new);
        CardPaymentResult cardPaymentResult = cardPayment.cardPayment(cardPaymentParameters);
        if (!cardPaymentResult.isSuccess()) {
            throw Xeption.forEndUser((String)cardPaymentResult.getErrorMessage(), (Object[])new Object[0]);
        }
        EntityContainer<Document> slipCtr = cardPaymentResult.getSlipDocument();
        if (Objects.nonNull(slipCtr)) {
            slipCtrs.put(cardPaymentParameters.getPayment(), slipCtr);
        }
        ctx.getRawData().putAll(cardPaymentResult.getCtx());
    }
}

