/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.ibus.card;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.IBusPgContextKeys;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.pg.card.CardPaymentUtils;
import java.util.Objects;
import java.util.Optional;

public class PrepareCardPaymentProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        if (ctx.hasObject((Enum)IBusMidofficeContextKeys.FOP)) {
            return;
        }
        PaymentType paymentType = (PaymentType)ctx.getObject((Enum)IBusGdsContextKeys.PAYMENT_TYPE);
        boolean isCardPayment = Optional.ofNullable(paymentType).map(CardPaymentUtils::cardPayment).isPresent();
        if (!isCardPayment) {
            return;
        }
        Fop fop = new Fop();
        fop.setType(paymentType);
        Card card = (Card)ctx.getObject((Enum)IBusPgContextKeys.SELECTED_PAYMENT_CARD);
        if (Objects.nonNull(card)) {
            fop.setCard(card);
        }
        ctx.putObject((Enum)IBusMidofficeContextKeys.FOP, (Object)fop);
    }
}

