/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.ibus.common;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.pg.IBusPgContextKeys;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class PgCheckPaymentSuccededProcessor
extends BaseProcessor {
    private int waitTimeInSeconds = 30;

    public void configure(Map<String, String> parameters) {
        String timeStr = parameters.get("wait-time-in-seconds");
        if (!TextUtil.isBlank((String)timeStr)) {
            this.waitTimeInSeconds = Integer.parseInt(timeStr.trim());
        }
    }

    public void process(MessageContext ctx) throws Exception {
        String orderUid = (String)ctx.getMandatoryObject((Enum)IBusPgContextKeys.ORDER_ID);
        long end = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(this.waitTimeInSeconds);
        String description = null;
        while (System.currentTimeMillis() < end) {
            EntityContainer ctr = EntityStorage.get().load(Payment.class, orderUid);
            if (ctr == null) {
                throw Xeption.forDeveloper((String)"\u043f\u043b\u0430\u0442\u0435\u0436 uid = {0} \u043d\u0435 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d", (Object[])new Object[]{orderUid});
            }
            description = ((Payment)ctr.getEntity()).getDescription();
            PaymentStatus status = ((Payment)ctr.getEntity()).getStatus();
            if (status == PaymentStatus.ERROR || status == PaymentStatus.FAILED) {
                throw Xeption.forEndUser((String)"\u043f\u0440\u0438 \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 {0} \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", (Object[])new Object[]{description});
            }
            if (((Payment)ctr.getEntity()).getStatus() == PaymentStatus.SUCCEEDED) {
                return;
            }
            Thread.sleep(1000L);
        }
        throw Xeption.forAdmin((String)"\u043f\u043b\u0430\u0442\u0435\u0436 {0} \u0437\u0430\u0432\u0438\u0441", (Object[])new Object[]{description});
    }
}

