/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.ibus.common;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.IBusPgContextKeys;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.pg.model.ProcessingStatus;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;

public class PgCreatePaymentProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        String uid = (String)ctx.getObject((Enum)IBusPgContextKeys.ORDER_ID);
        if (uid == null) {
            uid = UUIDGenerator.generate((boolean)true).toString();
        }
        EntityContainer resultCtr = new EntityContainer(Payment.class, uid);
        Payment result = (Payment)resultCtr.getEntity();
        EntityContainer bookingFileCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusPgContextKeys.BOOKING_CONTAINER);
        result.setPaymentId(uid);
        result.setDescription((String)ctx.getMandatoryObject((Enum)IBusPgContextKeys.BOOKING_DESCRIPTION));
        result.setPaymentType((PaymentType)ctx.getMandatoryObject((Enum)IBusPgContextKeys.PAYMENT_TYPE));
        result.setPg((PgName)ctx.getMandatoryObject((Enum)IBusPgContextKeys.PG_NAME));
        result.setAmount(BookingHelper.getTotalPrice((BookingFile)((BookingFile)bookingFileCtr.getEntity()), (ContractType)ContractType.CLIENT));
        result.setFee(PgCreatePaymentProcessor.getTotalFee((BookingFile)bookingFileCtr.getEntity(), ContractType.CLIENT));
        if (((BookingFile)bookingFileCtr.getEntity()).getCustomer() != null) {
            result.getCustomerInfo().setPreferredLocale(((BookingFile)bookingFileCtr.getEntity()).getCustomer().getPreferredLocale());
        }
        result.setEntity(bookingFileCtr.toReference());
        result.setPayee(((BookingFile)bookingFileCtr.getEntity()).getAgency());
        result.setPayer(((BookingFile)bookingFileCtr.getEntity()).getCustomerProfile());
        result.setStatus(PaymentStatus.INITIATED);
        result.setProcessingStatus(ProcessingStatus.NOT_PROCESSED);
        EntityStorage.get().save(resultCtr, false);
        ctx.putObject((Enum)IBusPgContextKeys.PAYMENT_CONTAINER, (Object)resultCtr);
    }

    private static BigDecimal getTotalFee(BookingFile bf, ContractType contractType) {
        BigDecimal result = BigDecimal.ZERO;
        for (Reservation reservation : bf.getReservations()) {
            for (BaseProduct product : reservation.getProducts()) {
                result = result.add(BookingHelper.calculateFee((BaseProduct)product, (ContractType)contractType));
            }
        }
        return result;
    }
}

