/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.ibus.common;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.pg.IBusPgContextKeys;
import com.gridnine.xtrip.common.pg.PgMultiLogDocument;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.DebugData;
import com.gridnine.xtrip.server.ibus.components.DebugHandler;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class PgDebugHandler
implements DebugHandler {
    private static final long serialVersionUID = -7297192634219628325L;
    private String loggerName = this.getClass().getName();
    private String operationName = null;

    public boolean isDebugDataDisabled(MessageContext ctx) {
        return false;
    }

    public void configure(Map<String, String> properties) {
        this.loggerName = properties.get("loggerName");
        if (this.loggerName == null) {
            this.loggerName = this.getClass().getName();
        }
        this.loggerName = String.format("com.gridnine.xtrip.server.ibus.%s", this.loggerName);
        this.operationName = properties.get("operationName");
    }

    public boolean isTraceData(String processorId, MessageContext ctx) {
        return true;
    }

    public void save(DebugData data, MessageContext ctx) throws Exception {
        LoggerFactory.getLogger((String)this.loggerName).debug(String.format("trace of route %s:\n%s", data.getRouteId(), data.buildDebugInfo(true)));
        String bookingUid = (String)ctx.getMandatoryObject((Enum)IBusPgContextKeys.BOOKING_UID);
        if (TextUtil.isBlank((String)bookingUid)) {
            return;
        }
        String sessionId = (String)ctx.getObject((Enum)IBusPgContextKeys.SESSION_ID);
        EntityContainer ctr = this.findExistingDocument(sessionId, bookingUid);
        if (ctr == null) {
            ctr = new EntityContainer(PgMultiLogDocument.class);
            ((PgMultiLogDocument)ctr.getEntity()).setSessionId(sessionId);
            ((PgMultiLogDocument)ctr.getEntity()).setCreated(new Date());
            ((PgMultiLogDocument)ctr.getEntity()).setName(String.format("pg_logs_%s.xml", this.getOperationName(ctx)));
            ((PgMultiLogDocument)ctr.getEntity()).setTitle("\u041b\u043e\u0433\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u043e\u0433\u043e \u0448\u043b\u044e\u0437\u0430 \u0434\u043b\u044f " + this.getOperationName(ctx));
            ((PgMultiLogDocument)ctr.getEntity()).setOwner(new EntityReference(bookingUid, BookingFile.class, null));
        }
        Document document = new Document();
        document.setContentType(ContentType.XML);
        document.setName(String.format("pg_logs_for_%s.xml", data.getRouteId()));
        document.setTitle(String.format("\u043b\u043e\u0433\u0438 %s", data.getRouteId()));
        document.setContent(data.buildDebugInfo(true).getBytes("utf-8"));
        ((PgMultiLogDocument)ctr.getEntity()).getDocuments().add(document);
        EntityStorage.get().save(ctr, false);
    }

    protected String getOperationName(MessageContext ctx) {
        return this.operationName;
    }

    private EntityContainer<PgMultiLogDocument> findExistingDocument(String sessionId, String bookingUid) {
        if (sessionId == null) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), (Object)new EntityReference(bookingUid, BookingFile.class, null)));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.type.name(), (Object)DocumentType.PG_TRACE));
        for (BasicDocumentIndex item : EntityStorage.get().search(BasicDocumentIndex.class, query).getData()) {
            PgMultiLogDocument mld;
            EntityContainer docCtr = EntityStorage.get().resolve(item.getSource());
            if (docCtr == null || !(docCtr.getEntity() instanceof PgMultiLogDocument) || !sessionId.equals((mld = (PgMultiLogDocument)docCtr.getEntity()).getSessionId())) continue;
            return docCtr;
        }
        return null;
    }
}

