/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.ibus.common;

import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.IBusPgContextKeys;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.pg.rules.Targets;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.pg.rules.proxy.PGParametersActions;
import com.gridnine.xtrip.server.pg.rules.proxy.PGParametersProperties;
import java.util.Collections;
import java.util.Date;

public class PgLoadPgParametersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusPgContextKeys.SALES_CONTEXT);
        RuleSet rules = SalesContextHandler.get().getRules(salesContext);
        RuleProxy proxy = new RuleProxy();
        proxy.setProxyType(Targets.PG_PARAMETERS.getId());
        proxy.setProxyDate(new Date());
        PgName pgName = (PgName)ctx.getMandatoryObject((Enum)IBusPgContextKeys.PG_NAME);
        Payment payment = new Payment();
        payment.setPg(pgName);
        PGParametersProperties props = PGParametersProperties.newInstance(pgName, payment);
        PaymentType pt = (PaymentType)ctx.getMandatoryObject((Enum)IBusPgContextKeys.PAYMENT_TYPE);
        props.setPaymentType(pt.name());
        GdsName gds = (GdsName)ctx.getMandatoryObject((Enum)IBusPgContextKeys.GDS_OF_FIRST_RESERVATION);
        props.setGds(gds.name());
        proxy.setPropertySet((Object)props);
        PGParametersActions actions = new PGParametersActions();
        proxy.setActionSet((Object)actions);
        proxy.getTracer().setDisabled(true);
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
        PGParameters result = new PGParameters();
        if (!TextUtil.isBlank((String)actions.getPgAccount())) {
            result.setPgAccount(actions.getPgAccount());
        }
        if (!TextUtil.isBlank((String)actions.getPgPassword())) {
            result.setPgPassword(actions.getPgPassword());
        }
        if (actions.getPgServiceUrl() != null) {
            result.setPgServiceUrl(actions.getPgServiceUrl());
        }
        if (actions.getPgRedirectUrl() != null) {
            result.setPgRedirectUrl(actions.getPgRedirectUrl());
        }
        result.getApplicablePG().addAll(actions.getApplicablePG());
        ctx.putObject((Enum)IBusPgContextKeys.PG_PARAMETERS, (Object)result);
        ctx.putObject((Enum)IBusPgContextKeys.PG_LOGIN, (Object)result.getPgAccount());
        ctx.putObject((Enum)IBusPgContextKeys.PG_PASSWORD, (Object)result.getPgPassword());
    }
}

