/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.ibus.common;

import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.pg.IBusPgContextKeys;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.pg.PgConfigurationCompaundKeyProvider;
import com.gridnine.xtrip.server.pg.ibus.common.PgCommonHelper;

public class PgRestoreContextForServletRequestProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        String pg_order_id = (String)ctx.getMandatoryObject((Enum)IBusPgContextKeys.PAYMENT_UID);
        EntityContainer paymentCtr = EntityStorage.get().load(Payment.class, pg_order_id);
        if (paymentCtr == null) {
            throw new IllegalStateException(String.format("payment with uid %s does not exist", pg_order_id));
        }
        Payment payment = (Payment)paymentCtr.getEntity();
        EntityContainer bookingCtr = EntityStorage.get().resolve(payment.getEntity());
        if (bookingCtr == null) {
            throw new IllegalStateException(String.format("booking %s does not exist", payment.getEntity()));
        }
        ctx.putObject((Enum)IBusPgContextKeys.BOOKING_CONTAINER, (Object)bookingCtr);
        BookingFile booking = (BookingFile)bookingCtr.getEntity();
        ctx.putObject((Enum)IBusPgContextKeys.GDS_OF_FIRST_RESERVATION, (Object)CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)((Reservation)booking.getReservations().get(0))));
        SalesContext salesContext = PgCommonHelper.restoreSalesContext((Reservation)booking.getReservations().get(0));
        ctx.putObject((Enum)IBusPgContextKeys.SALES_CONTEXT, (Object)salesContext);
        ctx.putObject((Enum)IBusPgContextKeys.BOOKING_UID, (Object)bookingCtr.getUid());
        ctx.putObject((Enum)IBusPgContextKeys.PAYMENT_CONTAINER, (Object)paymentCtr);
        EntityContainer settingsCtr = EntityStorage.get().find(BasicSystemSettingsIndex.class, BasicSystemSettingsIndex.Property.compoundKey.name(), (Object)PgConfigurationCompaundKeyProvider.getCompaundKey(payment.getPg()));
        if (settingsCtr != null) {
            ctx.putObject((Enum)IBusPgContextKeys.PG_CONFIGURATION, (Object)settingsCtr.getEntity());
        }
    }
}

