/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.ibus.common;

import com.gridnine.bof.midoffice.helper.MidofficeHelper;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.PredefinedContractRelationType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.pg.IBusPgContextKeys;
import com.gridnine.xtrip.common.util.UUIDUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

public class PgUpdateFopsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer bookingFileCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusPgContextKeys.CLONED_BOOKING_CONTAINER);
        Collection reservations = (Collection)ctx.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_RESERVATIONS);
        PaymentType pt = (PaymentType)ctx.getMandatoryObject((Enum)IBusPgContextKeys.PAYMENT_TYPE);
        SalesContext sc = (SalesContext)ctx.getMandatoryObject((Enum)IBusPgContextKeys.SALES_CONTEXT);
        EntityReference agent = sc.getAgent();
        for (Reservation res : MidofficeHelper.getReservations((EntityContainer)bookingFileCtr, (Collection)reservations)) {
            for (BaseProduct bp : res.getProducts()) {
                ProductHandler handler = HandlersRegistry.get().findProductHandler(bp.getClass());
                Date issueDate = handler.findIssueDate(bp);
                List relations = GeneralProductHelper.copyContractRelations((BaseProduct)bp);
                for (GeneralProductContractRelationData item : relations) {
                    VatAmount vatAmount = handler.calculateProductPrice(bp, GeneralProductHelper.getContractType((EntityReference)item.getDescription()));
                    BigDecimal price = vatAmount != null && vatAmount.getTotal() != null ? vatAmount.getTotal() : BigDecimal.ZERO;
                    EntityReference fopAgent = GeneralProductHelper.getContractType((EntityReference)item.getDescription()) == ContractType.VENDOR ? null : agent;
                    Iterator it = item.getFops().iterator();
                    while (it.hasNext()) {
                        GeneralProductFop fop = (GeneralProductFop)it.next();
                        if (GeneralProductHelper.isServiceFop((GeneralProductFop)fop)) {
                            it.remove();
                            continue;
                        }
                        fop.setUid(UUIDUtil.toString((UUID)UUID.randomUUID()));
                        fop.setAgent(fopAgent);
                        fop.setOperationDate(issueDate);
                        fop.setType(pt);
                    }
                    if (((ContractRelationDescription)EntityStorage.get().resolve(item.getDescription()).getEntity()).getPredefinedType() == PredefinedContractRelationType.TECHNICAL_PROVIDER_TO_AGENCY) continue;
                    GeneralProductFop fop = new GeneralProductFop();
                    fop.setEquivalentAmount(price);
                    fop.setAgent(fopAgent);
                    fop.setType(pt);
                    fop.setOperationDate(issueDate);
                    item.getFops().add(fop);
                }
                HandlersRegistry.get().findProductHandler(bp.getClass()).updateContractRelations(bp, relations);
            }
        }
    }
}

