/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.ibus.pgconnector;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.pg.model.PaymentCheckParameters;
import com.gridnine.xtrip.common.pg.model.PgPaymentCheck;
import com.gridnine.xtrip.common.pg.model.PgPaymentCheckIndex;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.pg.IBusPgContextKeys;
import com.gridnine.xtrip.server.pg.helper.PgPaymentCheckHelper;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FindPgPaymentCheckProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List messages;
        PaymentCheckParameters checkParameters = (PaymentCheckParameters)ctx.getMandatoryObject((Enum)IBusPgContextKeys.INPUT_PAYMENT_PARAMETERS);
        EntityContainer<PgPaymentCheck> pgPaymentCheckCtr = this.find(checkParameters);
        if (Objects.nonNull(pgPaymentCheckCtr)) {
            ctx.putObject((Enum)IBusPgConnectorContextKeys.PG_PAYMENT_CHECK, pgPaymentCheckCtr);
            messages = ((PgPaymentCheck)pgPaymentCheckCtr.getEntity()).getMessages();
        } else {
            messages = new ArrayList();
        }
        ctx.putObject((Enum)IBusPgConnectorContextKeys.PG_PAYMENT_CHECK_MESSAGES, messages);
    }

    private EntityContainer<PgPaymentCheck> find(PaymentCheckParameters checkParameters) {
        String paymentId = checkParameters.getPayment().getPaymentId();
        SearchResult<PgPaymentCheckIndex> searchResult = PgPaymentCheckHelper.findPgPaymentChecks(paymentId, 2);
        if (EntityStorageHelper.isEmpty(searchResult)) {
            return null;
        }
        List indexes = searchResult.getData();
        if (indexes.size() > 1) {
            throw Xeption.forDeveloper((String)"more than 1 {0} by paymentId={1}", (Object[])new Object[]{PgPaymentCheck.class.getName(), paymentId});
        }
        return EntityStorageHelper.resolve((EntityReference)((PgPaymentCheckIndex)indexes.get(0)).getSource());
    }
}

