/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.ibus.pgconnector;

import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentCheckParameters;
import com.gridnine.xtrip.common.pg.model.PgPaymentCheck;
import com.gridnine.xtrip.common.pg.model.PgPaymentCheckIndex;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.pg.PGConnectorRegistry;
import com.gridnine.xtrip.server.pg.helper.PgPaymentCheckHelper;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;

public class HandleUnfinishedPgCheckPaymentProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        block3: {
            EntityContainer pgPaymentCheckCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.PG_PAYMENT_CHECK);
            PgPaymentCheck pgPaymentCheck = (PgPaymentCheck)pgPaymentCheckCtr.getEntity();
            String paymentId = pgPaymentCheck.getPaymentId();
            SearchResult<PgPaymentCheckIndex> paymentChecks = PgPaymentCheckHelper.findPgPaymentChecks(paymentId, 2);
            if (paymentChecks.getData().size() > 1) {
                IncidentsLog.reportStackTrace((String)String.format("more than 1 %s with paymentId=%s", PgPaymentCheck.class.getSimpleName(), paymentId));
                return;
            }
            PaymentCheckParameters checkParameters = this.toPaymentCheckParameters(pgPaymentCheck);
            try {
                PGConnectorRegistry.get().get(pgPaymentCheck.getPgName()).checkPayment(checkParameters);
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) break block3;
                this.log.error("", (Throwable)e);
            }
        }
    }

    private PaymentCheckParameters toPaymentCheckParameters(PgPaymentCheck pgPaymentCheck) {
        PaymentCheckParameters checkParameters = new PaymentCheckParameters();
        Payment payment = new Payment();
        payment.setPaymentId(pgPaymentCheck.getPaymentId());
        checkParameters.setPg(pgPaymentCheck.getPgName());
        checkParameters.setPayment(payment);
        checkParameters.setSalesContext(pgPaymentCheck.getSalesContext());
        return checkParameters;
    }
}

