/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.ibus.pgconnector.check;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.fiscal.PaymentData;
import com.gridnine.xtrip.common.model.fiscal.PaymentMethod;
import com.gridnine.xtrip.common.model.fiscal.PaymentObject;
import com.gridnine.xtrip.common.model.fiscal.PaymentType;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.model.fiscal.ReceiptData;
import com.gridnine.xtrip.common.model.fiscal.ReceiptIndex;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLine;
import com.gridnine.xtrip.common.model.fiscal.ReceiptServiceType;
import com.gridnine.xtrip.common.model.fiscal.ReceiptStatus;
import com.gridnine.xtrip.common.model.fiscal.ReceiptType;
import com.gridnine.xtrip.common.model.fiscal.ReceiptVatType;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.pg.CommonCardPaymentHelper;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CreateReceiptProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Payment payment = (Payment)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.PAYMENT);
        boolean isAddBalance = NamedValueHelper.containsTrueForName((String)CommonCardPaymentHelper.IS_ADD_BALANCE, (Collection)payment.getCustomParameters());
        if (!isAddBalance) {
            return;
        }
        List<ReceiptIndex> receipts = this.findReceipts(payment);
        if (CollectionUtil.isNotEmpty(receipts)) {
            return;
        }
        Receipt receipt = this.newReceipt(payment);
        EntityContainer receiptCtr = EntityContainer.create((BaseEntity)receipt);
        ctx.putObject((Enum)IBusFinanceContextKeys.RECEIPT, (Object)receiptCtr);
    }

    private List<ReceiptIndex> findReceipts(Payment payment) {
        SearchQuery searchQuery = new SearchQuery();
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)ReceiptIndex.Property.paymentId.name(), (Object)payment.getPaymentId()));
        searchQuery.getPreferredProperties().add("uid");
        searchQuery.setLimit(1);
        SearchResult searchResult = EntityStorage.get().search(ReceiptIndex.class, searchQuery);
        return EntityStorageHelper.isEmpty((SearchResult)searchResult) ? Collections.emptyList() : searchResult.getData();
    }

    private Receipt newReceipt(Payment payment) {
        boolean hasErrorMessage;
        Receipt receipt = new Receipt();
        List messages = receipt.getMessages();
        receipt.setServiceType(ReceiptServiceType.ATOL_ONLINE);
        receipt.setStatus(ReceiptStatus.ERROR);
        receipt.setPaymentId(payment.getPaymentId());
        Date createDate = new Date();
        receipt.setCreated(createDate);
        receipt.setUpdated(createDate);
        receipt.setDescription(payment.getDescription());
        receipt.setOwner(payment.getPayer());
        EntityContainer payeeCtr = EntityStorageHelper.resolve((EntityReference)payment.getPayee());
        EntityContainer payerCtr = EntityStorageHelper.resolve((EntityReference)payment.getPayer());
        Organization payee = (Organization)payeeCtr.getEntity();
        EntityContainer atolSettingsCtr = EntityStorageHelper.resolve((EntityReference)payee.getAtolSettings());
        if (Objects.isNull(atolSettingsCtr)) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"{0} no atol settings", (Object[])new Object[]{payee.toString()}));
        } else {
            receipt.setAtolSettings(atolSettingsCtr.toReference());
        }
        ReceiptData receiptData = this.newReceiptData((EntityContainer<Organization>)payeeCtr, (EntityContainer<Organization>)payerCtr, payment.getAmount(), payment.getDescription(), messages);
        receipt.setReceiptData(receiptData);
        if (Objects.isNull(receiptData)) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"no receiptData", (Object[])new Object[0]));
        }
        if (!(hasErrorMessage = MessageHelper.hasMessages((Collection)messages, (MessageType)MessageType.ERROR))) {
            receipt.setStatus(ReceiptStatus.NEW);
        }
        return receipt;
    }

    private ReceiptData newReceiptData(EntityContainer<Organization> payeeCtr, EntityContainer<Organization> payerCtr, BigDecimal amount, String description, List<Message> messages) {
        ReceiptData receiptData = new ReceiptData();
        receiptData.setAgency(payeeCtr.toReference());
        receiptData.setClient(payerCtr.toReference());
        receiptData.setType(ReceiptType.SELL);
        Organization payer = (Organization)payerCtr.getEntity();
        Optional<String> emailOrganization = payer.getCommunications().stream().filter(Objects::nonNull).filter(communication -> CommunicationType.EMAIL == communication.getType()).map(Communication::getSense).filter(TextUtil::nonBlank).findAny();
        if (!emailOrganization.isPresent()) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} no email, use default", (Object[])new Object[]{payer.toString()}));
        }
        String clientEmail = emailOrganization.orElse("e.minaeva@vipservice.ru");
        receiptData.setClentEmail(clientEmail);
        ReceiptLine receiptLine = new ReceiptLine();
        receiptLine.setPrice(amount);
        receiptLine.setQuantity(BigDecimal.ONE);
        receiptLine.setTotal(amount);
        receiptLine.setVatType(ReceiptVatType.NONE);
        receiptLine.setVatAmount(BigDecimal.ZERO);
        receiptLine.setPrintName(description);
        receiptLine.setPaymentMethod(PaymentMethod.FULL_PAYMENT);
        receiptLine.setPaymentObject(PaymentObject.SERVICE);
        PaymentData paymentData = new PaymentData();
        paymentData.setType(PaymentType.ELECTRONIC);
        paymentData.setAmount(amount);
        receiptData.getItems().add(receiptLine);
        receiptData.getPayments().add(paymentData);
        return receiptData;
    }
}

