/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.ibus.pgconnector.check;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentCheckParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.pg.IBusPgContextKeys;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import java.util.Objects;

public class GetQueuePaymentProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        PaymentCheckParameters checkParameters = (PaymentCheckParameters)ctx.getMandatoryObject((Enum)IBusPgContextKeys.INPUT_PAYMENT_PARAMETERS);
        PGConnector pgConnector = (PGConnector)ctx.getMandatoryObject((Enum)IBusPgContextKeys.PG_CONNECTOR);
        Payment payment = (Payment)ctx.getObject((Enum)IBusPgConnectorContextKeys.PAYMENT);
        if (Objects.nonNull(payment)) {
            return;
        }
        Payment checkParametersPayment = checkParameters.getPayment();
        String paymentId = checkParametersPayment.getPaymentId();
        payment = pgConnector.getFromQueue(paymentId);
        if (Objects.isNull(payment)) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("Thinks that the payment's processed " + paymentId);
            }
            throw Xeption.forAdmin((String)("Payment " + paymentId + " not found in queue"), (Object[])new Object[0]);
        }
        String pgPaymentId = checkParametersPayment.getPgPaymentId();
        if (Objects.nonNull(pgPaymentId)) {
            payment.setPgPaymentId(pgPaymentId);
        }
        checkParameters.setPayment(payment);
        ctx.putObject((Enum)IBusPgConnectorContextKeys.PAYMENT, (Object)payment);
    }
}

