/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.ibus.pgconnector.core;

import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.AdviceOnExceptionCallback;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import java.util.Map;

public class AddContextMessageProcessor
extends BaseProcessor {
    private String message;
    private MessageType messageType;

    public void configure(Map<String, String> parameters) {
        this.message = parameters.get("message");
        this.messageType = MessageType.valueOf((String)parameters.get("message-type"));
    }

    public void process(MessageContext ctx) throws Exception {
        Payment payment = (Payment)ctx.getObject((Enum)IBusPgConnectorContextKeys.PAYMENT);
        Message systemMsg = SystemHelper.createMessage((MessageType)this.messageType, (String)this.message, (Object[])new Object[0]);
        if (payment != null) {
            this.addPaymentDetails(payment, systemMsg);
        }
        this.addStacktrace(ctx, systemMsg);
        ctx.addMessage(systemMsg);
    }

    private void addStacktrace(MessageContext ctx, Message systemMsg) {
        AdviceOnExceptionCallback callback = (AdviceOnExceptionCallback)ctx.getObject((Enum)IBusStandardContextKeys.ADVICE_ON_EXCEPTION_CALLBACK);
        if (callback != null) {
            systemMsg.setDetails(systemMsg.getDetails() + "\n" + TextUtil.getExceptionStackTrace((Throwable)callback.getException()));
        }
    }

    private void addPaymentDetails(Payment payment, Message systemMsg) {
        StringBuilder sb = new StringBuilder();
        if (payment.getPgPaymentId() != null) {
            sb.append("PgPaymentId=" + payment.getPgPaymentId());
        }
        if (payment.getPaymentType() != null) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append("paymentType=" + payment.getPaymentType().name());
        }
        systemMsg.setDetails(sb.toString());
    }
}

