/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.ibus.pgconnector.core;

import com.gridnine.xtrip.common.model.system.HttpRequest;
import com.gridnine.xtrip.common.model.system.HttpResponse;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.server.ibus.IbusHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HttpTraceProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        HttpRequest httpRequest = (HttpRequest)ctx.getMandatoryObject((Enum)IBusHttpContextKeys.HTTP_REQUEST);
        HttpResponse httpResponse = (HttpResponse)ctx.getMandatoryObject((Enum)IBusHttpContextKeys.HTTP_RESPONSE);
        List traces = (List)IbusHelper.getObjectN((MessageContext)ctx, (Enum)IBusPgConnectorContextKeys.TRACES, ArrayList::new);
        Document traceRequest = this.traceRequest(httpRequest, httpResponse);
        traces.add(traceRequest);
    }

    private Document traceRequest(HttpRequest httpRequest, HttpResponse httpResponse) {
        Document doc = DocumentBuilderHelper.newDocument();
        Element root = doc.createElement("transaction");
        root.setAttribute("date", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()));
        Element request = XmlUtil.addElement((Element)root, (String)"request");
        Element element = XmlUtil.addElement((Element)request, (String)"headers");
        XmlUtil.setValue((Element)element, (String)httpRequest.getRequestProperties().toString());
        element = XmlUtil.addElement((Element)request, (String)"url");
        XmlUtil.setValue((Element)element, (String)httpRequest.getUrl());
        element = XmlUtil.addElement((Element)request, (String)"method");
        XmlUtil.setValue((Element)element, (String)httpRequest.getRequestMethod().name());
        if (httpRequest.getBody() != null) {
            element = XmlUtil.addElement((Element)request, (String)"body");
            CDATASection cdata = doc.createCDATASection("mycdata");
            try {
                cdata.setData(URLDecoder.decode(new String(httpRequest.getBody()), "UTF-8"));
            }
            catch (Exception e) {
                cdata.setData(new String(httpRequest.getBody()));
                this.log.error("", (Throwable)e);
            }
            element.appendChild(cdata);
        }
        StringBuilder sb = new StringBuilder();
        Set entrySet = httpRequest.getQueryParameters().entrySet();
        for (Map.Entry entry : entrySet) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append((String)entry.getKey()).append("=");
            if (((String[])entry.getValue()).length == 1) {
                sb.append(((String[])entry.getValue())[0]);
                continue;
            }
            sb.append(Arrays.toString((Object[])entry.getValue()));
        }
        element = XmlUtil.addElement((Element)request, (String)"queryParameters");
        CDATASection cdata = doc.createCDATASection("mycdata");
        cdata.setData(sb.toString());
        element.appendChild(cdata);
        Element response = XmlUtil.addElement((Element)root, (String)"response");
        element = XmlUtil.addElement((Element)response, (String)"responseCode");
        XmlUtil.setValue((Element)element, (String)String.valueOf(httpResponse.getResponseCode()));
        if (httpResponse.getResponseMessage() != null) {
            element = XmlUtil.addElement((Element)response, (String)"responseText");
            cdata = doc.createCDATASection("mycdata");
            cdata.setData(new String(httpResponse.getResponseMessage()));
            element.appendChild(cdata);
        }
        if (httpResponse.getBody() != null) {
            element = XmlUtil.addElement((Element)response, (String)"body");
            cdata = doc.createCDATASection("mycdata");
            cdata.setData(new String(httpResponse.getBody()));
            element.appendChild(cdata);
        }
        if (httpResponse.getError() != null) {
            element = XmlUtil.addElement((Element)response, (String)"responseError");
            cdata = doc.createCDATASection("mycdata");
            cdata.setData(new String(httpResponse.getError()));
            element.appendChild(cdata);
        }
        doc.appendChild(root);
        return doc;
    }
}

