/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.ibus.pgconnector.core;

import com.gridnine.bof.midoffice.trace.TraceDataPolicy;
import com.gridnine.bof.midoffice.trace.TraceItem;
import com.gridnine.bof.midoffice.trace.Tracer;
import com.gridnine.bof.midoffice.trace.TracerConfiguration;
import com.gridnine.bof.midoffice.trace.UnlimitedFilesPolicy;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.pg.model.BasePaymentParameters;
import com.gridnine.xtrip.common.pg.model.PaymentCheckParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.DebugData;
import com.gridnine.xtrip.server.ibus.components.DebugHandler;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.pg.IBusPgContextKeys;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgConnectorDebugHandler
implements DebugHandler {
    protected static final transient Logger log = LoggerFactory.getLogger(PgConnectorDebugHandler.class);
    private static final long serialVersionUID = -8098570504517260730L;
    private Tracer tracer;
    private String operationName;

    public boolean isDebugDataDisabled(MessageContext ctx) {
        return false;
    }

    public void configure(Map<String, String> properties) {
        this.operationName = properties.get("operation-name");
        TracerConfiguration config = new TracerConfiguration();
        config.setFolder(new File(Environment.getTempFolder(), "ibus-pgconnector-trace"));
        config.setPolicy((TraceDataPolicy)new UnlimitedFilesPolicy());
        this.tracer = new Tracer();
        this.tracer.setConfiguration(config);
    }

    public boolean isTraceData(String processorId, MessageContext ctx) {
        return false;
    }

    public void save(DebugData data, MessageContext ctx) throws Exception {
        this.tracer.trace(new TraceItem[]{new TraceItemImpl(data, ctx, this.operationName)});
    }

    static class TraceItemImpl
    implements TraceItem {
        private final String id;
        private final byte[] content;

        TraceItemImpl(DebugData data, MessageContext ctx, String operationName) {
            this.id = String.format("%s-%s-%s.xml", operationName, TraceItemImpl.buildIds(ctx), Long.toString(MiscUtil.getTimestamp())).replaceAll("[^a-zA-Z\u0430-\u044f\u0410-\u042f0-9.-]", ",");
            this.content = data.buildDebugInfo(true).getBytes();
        }

        public String getId() {
            return this.id;
        }

        public void write(OutputStream strm) throws IOException {
            strm.write(this.content);
        }

        private static String buildIds(MessageContext ctx) {
            try {
                StringBuilder sb = new StringBuilder();
                BasePaymentParameters inputParams = (BasePaymentParameters)ctx.getMandatoryObject((Enum)IBusPgContextKeys.INPUT_PAYMENT_PARAMETERS);
                if (inputParams.getPg() != null) {
                    sb.append(inputParams.getPg().name()).append("_");
                }
                if (inputParams instanceof PaymentInitiationParameters) {
                    PaymentInitiationParameters input = (PaymentInitiationParameters)inputParams;
                    if (!TextUtil.isBlank((String)input.getPayment().getUid())) {
                        sb.append(input.getPayment().getUid()).append("_");
                    }
                    if (!TextUtil.isBlank((String)input.getPayment().getPaymentId())) {
                        sb.append(input.getPayment().getPaymentId()).append("_");
                    }
                    if (!TextUtil.isBlank((String)input.getPayment().getPgPaymentId())) {
                        sb.append(input.getPayment().getPgPaymentId()).append("_");
                    }
                } else {
                    PaymentCheckParameters input = (PaymentCheckParameters)inputParams;
                    if (input.getPayment() != null) {
                        if (!TextUtil.isBlank((String)input.getPayment().getPaymentId())) {
                            sb.append(input.getPayment().getPaymentId()).append("_");
                        }
                        if (!TextUtil.isBlank((String)input.getPayment().getPgPaymentId())) {
                            sb.append(input.getPayment().getPgPaymentId()).append("_");
                        }
                    }
                }
                return sb.toString();
            }
            catch (Exception e) {
                log.warn("", (Throwable)e);
                return "unknown-data";
            }
        }
    }
}

