/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.ibus.pgconnector.core;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class TracerProcessor
extends BaseProcessor {
    private String operationName;

    private static DateFormat createDf() {
        return new SimpleDateFormat("yyyy/MM/dd");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageContext ctx) throws Exception {
        List traces = (List)ctx.getObject((Enum)IBusPgConnectorContextKeys.TRACES);
        if (traces == null || traces.size() == 0) {
            return;
        }
        Payment payment = (Payment)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.PAYMENT);
        PgName pgName = payment.getPg();
        File folder = new File(Environment.getTempFolder(), "pg-trace/" + pgName.name());
        folder = new File(folder, TracerProcessor.createDf().format(new Date()));
        String fileName = String.format("%s-%s.xml", this.operationName, MiscUtil.getTimestamp());
        if (!folder.exists() && !folder.mkdirs()) {
            throw Xeption.forDeveloper((String)("Couldn't create " + folder), (Object[])new Object[0]);
        }
        File file = new File(folder, fileName);
        try (BufferedOutputStream strm = new BufferedOutputStream(new FileOutputStream(file, true));){
            for (Document document : traces) {
                TracerProcessor.printDocument(document, strm);
            }
        }
    }

    public static void printDocument(Document doc, OutputStream out) throws IOException, TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter(out, "UTF-8")));
    }

    public void configure(Map<String, String> parameters) {
        this.operationName = parameters.get("operation-name");
    }
}

