/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.ibus.pgconnector.refund;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class CreateRefundPaymentsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List payments = (List)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.PAYMENTS);
        EntityContainer bookingFileCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        List products = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS);
        EntityStorageContext storageContext = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Set refundedProducts = BookingHelper.getProducts((BookingFile)((BookingFile)bookingFileCtr.getEntity())).stream().filter(products::contains).map(product -> {
            ProductHandler handler = ProductHandler.of((BaseProduct)product);
            BaseProduct nextProduct = handler.getNextProduct(product);
            if (nextProduct != null && handler.getStatus(nextProduct) == ProductStatus.REFUND) {
                return nextProduct;
            }
            if (handler.getStatus(product) == ProductStatus.REFUND || handler.getStatus(product) == ProductStatus.EXCHANGE || handler.getStatus(product) == ProductStatus.VOID) {
                return product;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        Map<Reservation, List<BaseProduct>> reservationListMap = refundedProducts.stream().collect(Collectors.groupingBy(BaseProduct::getReservation));
        ArrayList<EntityContainer<Payment>> paymentContainers = new ArrayList<EntityContainer<Payment>>();
        block0: for (Map.Entry<Reservation, List<BaseProduct>> entry : reservationListMap.entrySet()) {
            Reservation reservation = entry.getKey();
            for (Payment payment : payments) {
                if (!payment.getReservations().contains(reservation.getUid())) continue;
                EntityContainer<Payment> refundPaymentCtr = this.createRefundPayment(payment);
                ((Payment)refundPaymentCtr.getEntity()).getReservations().add(reservation.getUid());
                ((Payment)refundPaymentCtr.getEntity()).setDescription("\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0431\u0440\u043e\u043d\u0438: " + CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation));
                ((Payment)refundPaymentCtr.getEntity()).setAmount(entry.getValue().stream().map(product -> BookingHelper.getTotalPrice((BaseProduct)product, (ContractType)ContractType.CLIENT, (boolean)true).abs()).reduce(BigDecimal::add).orElseThrow(IllegalArgumentException::new));
                EntityStorageHelper.registerContainer(refundPaymentCtr, (EntityStorageContext)storageContext);
                paymentContainers.add(refundPaymentCtr);
                continue block0;
            }
        }
        ctx.putObject((Enum)IBusPgConnectorContextKeys.PAYMENT_CONTAINERS, paymentContainers);
        ctx.putObject((Enum)IBusMidofficeContextKeys.REFUNDED_PRODUCTS, new ArrayList(refundedProducts));
    }

    private EntityContainer<Payment> createRefundPayment(Payment sourcePayment) {
        Payment result = new Payment();
        result.setStatus(PaymentStatus.INITIATED);
        result.setPg(sourcePayment.getPg());
        result.setPaymentId(sourcePayment.getPaymentId());
        result.setPaymentType(sourcePayment.getPaymentType());
        result.setPgPaymentId(sourcePayment.getPgPaymentId());
        result.setPayee(sourcePayment.getPayee());
        result.setPayer(sourcePayment.getPayer());
        result.setEntity(sourcePayment.getEntity());
        return EntityContainer.create((BaseEntity)result);
    }
}

