/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.ibus.pgconnector.refund;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.pg.model.PgPaymentIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class FindBookingPaymentsProcessor
extends BaseProcessor {
    private PgName pgName;

    public void configure(Map<String, String> parameters) {
        this.pgName = PgName.valueOf((String)Objects.requireNonNull(parameters.get("pgName"), "Missing required payment gate name!"));
    }

    public void process(MessageContext ctx) throws Exception {
        EntityContainer bookingFileCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        EntityStorage storage = EntityStorage.get();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)PgPaymentIndex.Property.status.name(), (Object)PaymentStatus.SUCCEEDED), SearchCriterion.eq((String)PgPaymentIndex.Property.pg.name(), (Object)this.pgName), SearchCriterion.eq((String)PgPaymentIndex.Property.entity.name(), (Object)bookingFileCtr.toReference())}));
        List payments = storage.search(PgPaymentIndex.class, query).getData().stream().map(PgPaymentIndex::getSource).map(arg_0 -> ((EntityStorage)storage).resolve(arg_0)).filter(Objects::nonNull).map(EntityContainer::getEntity).collect(Collectors.toList());
        if (payments.isEmpty()) {
            throw Xeption.forEndUser((String)String.format("Can't find previous payments in PG %s for booking [%s]", ((BookingFile)bookingFileCtr.getEntity()).getNumber(), this.pgName), (Object[])new Object[0]);
        }
        ctx.putObject((Enum)IBusPgConnectorContextKeys.PAYMENTS, payments);
    }
}

