/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.ibus.report;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.pg.model.GetPaymentsReportParameters;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PGRulesHelper;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;

public class ReportPgParametersResolverProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SalesContext salesContext = (SalesContext)ctx.getObject(IBusMidofficeContextKeys.SALES_CONTEXT.name());
        GetPaymentsReportParameters params = (GetPaymentsReportParameters)ctx.getObject(IBusPgConnectorContextKeys.GET_PAYMENTS_REPORT_PARAMETERS.name());
        Payment payment = new Payment();
        payment.setPg(params.getPg());
        payment.getCustomParameters().addAll(params.getCustomParameters());
        PGParameters pgParameters = PGRulesHelper.getPGParameters(salesContext, params.getPg(), payment);
        if (pgParameters == null || TextUtil.isBlank((String)pgParameters.getPgAccount())) {
            throw new PGException("PgAccount isn't filled");
        }
        ctx.putObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT, (Object)salesContext);
        ctx.putObject((Enum)IBusPgConnectorContextKeys.SALES_POINT_PG_PARAMETERS, (Object)pgParameters);
        ctx.putObject((Enum)IBusPgConnectorContextKeys.PAYMENT, (Object)payment);
    }
}

